% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planes.R
\name{plane_repeat}
\alias{plane_repeat}
\title{Repeat component}
\usage{
plane_repeat(location, input, seed, tolerance = NULL, prepend = NULL)
}
\arguments{
\item{location}{Character vector with location code; the location must appear in input and seed}

\item{input}{Input signal data to be scored; object must be one of \link[=to_signal]{forecast} or \link[=to_signal]{observed}}

\item{seed}{Prepared \link[=plane_seed]{seed}}

\item{tolerance}{Integer value for the number of allowed repeats before flag is raised. Default is \code{NULL} and allowed repeats will be determined from seed.}

\item{prepend}{Integer value for the number of values from seed to add before the evaluated signal. Default is \code{NULL} and the number of values will be determined from seed.}
}
\value{
A \code{list} with the following values:
\itemize{
\item \strong{indicator}: Logical as to whether or not the value is repeated sequentially k number of times.
\item \strong{repeats}: A \code{tibble} with repeating values found. If there are no repeats (i.e., indicator is \code{FALSE}) then the \code{tibble} will have 0 rows.
}
}
\description{
This function evaluates whether consecutive values in observations or forecasts are repeated a k number of times. This function takes in a \link[=to_signal]{forecast} or \link[=to_signal]{observed} object that is either from an observed dataset or forecast dataset. Note that if a signal is contant (i.e., the same value is repeated for all time points) then the repeat component will return \code{FALSE}.
}
\examples{
## read in example observed data and prep observed signal
hosp <- read.csv(system.file("extdata/observed/hdgov_hosp_weekly.csv", package = "rplanes"))
hosp$date <- as.Date(hosp$date, format = "\%Y-\%m-\%d")
prepped_observed <- to_signal(hosp, outcome = "flu.admits", type = "observed", resolution = "weeks")

## read in example forecast and prep forecast signal
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
prepped_forecast <- read_forecast(fp) \%>\%
  to_signal(., outcome = "flu.admits", type = "forecast", horizon = 4)

## prepare seed with cut date
prepped_seed <- plane_seed(prepped_observed, cut_date = "2022-10-29")

## run plane component
## use defaults
plane_repeat(location = "12", input = prepped_forecast, seed = prepped_seed)
## set tolerated repeats to 2
plane_repeat(location = "12", input = prepped_forecast, seed = prepped_seed, tolerance = 2)

## use defaults
plane_repeat(location = "49", input = prepped_forecast, seed = prepped_seed)
## set number of values prepended for evaluation to 4
plane_repeat(location = "49", input = prepped_forecast, seed = prepped_seed, prepend = 4)

}
