% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{regex-helpers}
\alias{regex-helpers}
\alias{re_extract}
\alias{extract_backticked}
\alias{extract_quoted}
\alias{is_backticked}
\alias{is_bracketed}
\title{A half-baked extract method}
\usage{
re_extract(pattern, replace, x)

extract_backticked(x)

extract_quoted(x)

is_backticked(x)

is_bracketed(x)
}
\arguments{
\item{pattern}{character string containing a \link[base]{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link[base]{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr}, \code{gregexpr} and \code{regexec}.}
}
\value{
(\code{character[1]}) The substituted string if a replacement is made, or \code{NULL} otherwise.
}
\description{
A half-baked extract method
}
\section{Functions}{
\itemize{
\item \code{extract_backticked()}: Extract contents of a backtick-enclosed string

\item \code{extract_quoted()}: Extract contents of a quoted (single or double) string

\item \code{is_backticked()}: Extract contents of a backtick-enclosed string

\item \code{is_bracketed()}: Test whether contents are enclosed in brackets

}}
\note{
This implementation is considered half-baked because there's no check for
whether a replacement is made that results in the same string. This case
will be interpreted the same as if there was no match.
}
\keyword{internal}
