% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entity.R
\name{get_entity}
\alias{get_entity}
\title{Get entity(ies)}
\usage{
get_entity(rocrate, id = NULL, type = NULL)
}
\arguments{
\item{rocrate}{RO-Crate object, see \link{rocrate}.}

\item{id}{String with the ID of the RO-Crate entity within \verb{@graph}
(optional if \code{type} is provided). Alternatively, an entity object / list
with \verb{@id} and \verb{@type}.}

\item{type}{String with the type of the RO-Crate entity(ies) within \verb{@graph}
to retrieve (optional if \code{id} is provided).}
}
\value{
List with found entity object(s), if any, \code{NULL} otherwise.
}
\description{
Get entity(ies)
}
\examples{
basic_crate <- rocrateR::rocrate()

# create entity for an organisation
organisation_uol <- rocrateR::entity(
  x = "https://ror.org/04xs57h96",
  type = "Organization",
  name = "University of Liverpool",
  url = "http://www.liv.ac.uk"
)

# create an entity for a person
person_rvd <- rocrateR::entity(
  x = "https://orcid.org/0000-0001-5036-8661",
  type = "Person",
  name = "Roberto Villegas-Diaz",
  affiliation = list(`@id` = organisation_uol$`@id`)
)

basic_crate_person <- basic_crate |>
  rocrateR::add_entity(person_rvd) |>
  rocrateR::add_entity_value(id = "./", key = "author", value = list(`@id` = person_rvd$`@id`)) |>
  rocrateR::add_entity(organisation_uol) |>
  rocrateR::get_entity(person_rvd)
  
basic_crate_person[[1]]$name == person_rvd$name
basic_crate_person[[1]]$`@id` == person_rvd$`@id`
}
