% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest.R
\name{quest}
\alias{quest}
\title{Qualitative/Unified Exploration of State Transitions}
\usage{
quest(
  x,
  rawClassIdentifierCol = "state_raw",
  labelFun = base::round,
  labelFunArgs = list(digits = 2)
)
}
\arguments{
\item{x}{A parsed source document as provided by \code{\link[=parse_source]{parse_source()}}.}

\item{rawClassIdentifierCol}{The identifier of the column in \code{x}'s QDT with
the raw class codings of the class that has the states to look at.}

\item{labelFun}{A function to apply to the edge labels in preprocessing.}

\item{labelFunArgs}{Arguments to specify to \code{labelFun} in addition to the
first argument (the edge weight, a number).}
}
\value{
A \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}} object, which will print to show the
QUEST graph.
}
\description{
Qualitative/Unified Exploration of State Transitions
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "state-example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source(exampleFile);

### Show a QUEST graph
rock::quest(
  parsedExample
);

}
