% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qna_to_ltm.R
\name{qna_to_tlm}
\alias{qna_to_tlm}
\title{Convert a QNA network to Linear Topic Map format}
\usage{
qna_to_tlm(
  x,
  topicmapId = "rock_qna_topicmap",
  topicmapTitle = "A ROCK QNA Topic Map"
)
}
\arguments{
\item{x}{The parsed source object (as produced by \code{\link[=parse_source]{parse_source()}}),
or an object holding multiple parsed sources (as produced
by \code{\link[=parse_sources]{parse_sources()}}).}

\item{topicmapId, topicmapTitle}{The topic map's identifier and title.}
}
\value{
If \code{x} is a single parsed source: a character vector holding the
Linear Topic Map specification; or, if multiple network coding schemes were
used in parallel, each in a list. If \code{x} contains multiple parseds sources,
a list of such objects (i.e., a list of vectors, or a list of lists of
vectors).
}
\description{
The Linear Topic Map format, LTM (\url{https://ontopia.net/download/ltm.html}),
allows specification of networks in a human-readable format.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Read a souce coded with the Qualitative Network Approach
qnaExample <-
  rock::parse_source(
    file.path(
      examplePath,
      "network-example-1.rock"
    )
  );

### Convert and show the topic map
cat(
  rock::qna_to_tlm(
    qnaExample
  ),
  sep="\n"
);

}
