% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confIntProp.R
\name{confIntProp}
\alias{confIntProp}
\title{Confidence intervals for proportions, vectorized over all arguments}
\usage{
confIntProp(x, n, conf.level = 0.95, plot = FALSE)
}
\arguments{
\item{x}{The number of 'successes', i.e. the number of events, observations,
or cases that one is interested in.}

\item{n}{The total number of cases or observatons.}

\item{conf.level}{The confidence level.}

\item{plot}{Whether to plot the confidence interval in the binomial distribution.}
}
\value{
The confidence interval bounds in a twodimensional matrix, with the
first column containing the lower bound and the second column containing the
upper bound.
}
\description{
This function simply computes confidence intervals for proportions.
}
\details{
This function is the adapted source code of \code{\link[=binom.test]{binom.test()}}. It
uses \code{\link[=pbeta]{pbeta()}}, with some lines of code taken from the
\code{\link[=binom.test]{binom.test()}} source. Specifically, the count for the low
category is specified as first 'shape argument' to \code{\link[=pbeta]{pbeta()}}, and
the total count (either the sum of the count for the low category and the
count for the high category, or the total number of cases if
\code{compareHiToLo} is \code{FALSE}) minus the count for the low category
as the second 'shape argument'.
}
\examples{

  ### Simple case
  rock::confIntProp(84, 200);

  ### Using vectors
  rock::confIntProp(c(2,3), c(10, 20), conf.level=c(.90, .95, .99));

}
\seealso{
\code{\link[=binom.test]{binom.test()}}
}
\author{
Unknown (see \code{\link[=binom.test]{binom.test()}}; adapted by Gjalt-Jorn Peters)

Maintainer: Gjalt-Jorn Peters \href{mailto:rock@opens.science}{rock@opens.science}
}
\keyword{htest}
\keyword{univar}
