% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robregcc.R
\name{robregcc_sim}
\alias{robregcc_sim}
\title{Simulation data}
\usage{
robregcc_sim(n, betacc, beta0, O, Sigma, levg, snr, shft, m, C, out = list())
}
\arguments{
\item{n}{sample size}

\item{betacc}{model parameter satisfying compositional covariates}

\item{beta0}{intercept}

\item{O}{number of outlier}

\item{Sigma}{covariance matrix of simulated predictors}

\item{levg}{1/0 whether to include leveraged observation or not}

\item{snr}{noise to signal ratio}

\item{shft}{multiplying factor to model variance for creating outlier}

\item{m}{test sample size}

\item{C}{subcompositional matrix}

\item{out}{list for obtaining output with simulated data structure}
}
\value{
a list containing simulated output.
}
\description{
Simulate data for the robust regression with compositional covariates
}
\examples{
 
## Simulation example:
library(robregcc)
library(magrittr)

## n: sample size 
## p: number of predictors
## o: fraction of observations as outliers
## L: {0,1} => leveraged {no, yes}, 
## s: multiplicative factor 
## ngrp: number of subgroup in the model 
## snr: noise to signal ratio for computing true std_err

## Define parameters to simulate example
p <- 80                # number of predictors  
n <- 300               # number of sample   
O <- 0.10*n            # number of outlier
L <- 1                             
s <- 8                          
ngrp <- 4              # number of sub-composition
snr <- 3               # Signal to noise ratio
example_seed <- 2*p+1  # example seed
set.seed(example_seed) 
# Simulate subcomposition matrix
C1 <- matrix(0,ngrp,23)
tind <- c(0,10,16,20,23)
for (ii in 1:ngrp)
  C1[ii,(tind[ii] + 1):tind[ii + 1]] <- 1
C <- matrix(0,ngrp,p)
C[,1:ncol(C1)] <- C1            
# model parameter beta
beta0 <- 0.5
beta <- c(1, -0.8, 0.4, 0, 0, -0.6, 0, 0, 0, 0, -1.5, 0, 1.2, 0, 0, 0.3)
beta <- c(beta,rep(0,p - length(beta)))
# Simulate response and predictor, i.e., X, y
Sigma  <- 1:p \%>\% outer(.,.,'-') \%>\% abs(); Sigma  <- 0.5^Sigma
data.case <- vector("list",1)
set.seed(example_seed)
data.case <- robregcc_sim(n,beta,beta0, O = O,
      Sigma,levg = L, snr,shft = s,0, C,out = data.case)
data.case$C <- C                         
# We have saved a copy of simulated data in the package 
# with name simulate_robregcc 
# simulate_robregcc = data.case;
# save(simulate_robregcc, file ='data/simulate_robregcc.rda')

X <- data.case$X                 # predictor matrix
y <- data.case$y                 # model response 


}
\references{
Mishra, A., Mueller, C.,(2019) \emph{Robust regression with compositional covariates. In prepration.} arXiv:1909.04990.
}
