% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimmedTest.R
\name{trimmed_test}
\alias{trimmed_test}
\title{Two-sample trimmed t-test (Yuen's t-Test)}
\usage{
trimmed_test(
  x,
  y,
  gamma = 0.2,
  alternative = c("two.sided", "less", "greater"),
  method = c("asymptotic", "permutation", "randomization"),
  delta = ifelse(scale.test, 1, 0),
  n.rep = 1000,
  na.rm = FALSE,
  scale.test = FALSE,
  wobble.seed = NULL
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{gamma}{a numeric value in [0, 0.5] specifying the fraction of observations
to be trimmed from each end of the sample before calculating the
mean. The default value is 0.2.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater", or "less".}

\item{method}{a character string specifying how the p-value is computed with
possible values \code{"asymptotic"} for an asymptotic test
based on a normal approximation, \code{"permutation"} for a
permutation test, and \code{"randomization"} for a randomization
test. The permutation test uses all splits of the joint sample
into two samples of sizes \code{m} and \code{n}, while the
randomization test draws \code{n.rep} random splits with
replacement. The values \code{m} and \code{n} denote the
sample sizes.
If not specified explicitly, defaults to
\code{"permutation"}  if \code{m < 30}, \code{n < 30} and
 \code{n.rep >= choose(m + n, m)},
\code{"randomization"} if \code{m < 30}, \code{n < 30} and
 \code{n.rep < choose(m + n, m)}, and
 \code{"asymptotic"} if \code{m >= 30} and \code{n >= 30}.}

\item{delta}{a numeric value indicating the true difference in the location or
scale parameter, depending on whether the test should be performed
for a difference in location or in scale. The default is
\code{delta = 0} for a location test and \code{delta = 1} for a scale
test. In case of \code{scale.test = TRUE}, \code{delta} represents
the ratio of the squared scale parameters.}

\item{n.rep}{an integer value specifying the number of random splits used to
calculate the randomization distribution if \code{method = "randomization"}.
This argument is ignored if \code{method = "permutation"} or \code{method = "asymptotic"}.
The default is \code{n.rep = 10000}.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and
\code{y} should be stripped before the computation proceeds. The
default is \code{na.rm = FALSE}.}

\item{scale.test}{a logical value to specify if the samples should be compared
for a difference in scale. The default is \code{scale.test = FALSE}.}

\item{wobble.seed}{an integer value used as a seed for the random number
generation in case of \code{wobble = TRUE} or when
\code{scale.test = TRUE} with one of the vectors \code{x} and
\code{y} containing zeros. When no seed is specified, it
is chosen randomly and printed in a message. The argument
is ignored if \code{scale.test = FALSE} and/or \code{wobble = FALSE}.}
}
\value{
A named list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom for the test statistic.}
\item{p.value}{the p-value for the test.}
\item{estimate}{the trimmed means of \code{x} and \code{y}
                (if \code{scale.test = FALSE}) or of \code{log(x^2)} and
                \code{log(y^2)} (if \code{scale.test = TRUE}).}
\item{null.value}{the specified hypothesized value of the mean difference/squared
                  scale ratio.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating how the p-value was computed.}
\item{data.name}{a character string giving the names of the data.}
}
\description{
\code{trimmed_test} performs the two-sample trimmed t-test.
}
\details{
The function performs Yuen's t-test based on the trimmed mean and winsorized
variance \insertCite{YueDix73appr}{robnptests}.
The amount of trimming/winsorization is set in \code{gamma} and
defaults to 0.2, i.e. 20\% of the values are removed/replaced.
In addition to the asymptotic distribution a permutation and a
randomization version of the test are implemented.

When computing a randomization distribution based on randomly drawn splits
with replacement, the function \code{\link[statmod]{permp}} \insertCite{PhiSmy10perm}{robnptests}
is used to calculate the p-value.

For \code{scale.test = TRUE}, the test compares the two samples for a difference
in scale. This is achieved by log-transforming the original squared observations,
i.e. \code{x} is replaced by \code{log(x^2)} and \code{y} by \code{log(y^2)}.
A potential scale difference then appears as a location difference between
the transformed samples, see \insertCite{Fri12onli;textual}{robnptests}.
Note that the samples need to have equal locations. The sample should not
contain zeros to prevent problems with the necessary log-transformation. If
it contains zeros, uniform noise is added to all variables in order to remove
zeros and a message is printed.

If the sample has been modified because of zeros when \code{scale.test = TRUE},
the modified samples can be retrieved using

\code{set.seed(wobble.seed); wobble(x, y)}

Both samples need to contain at least 5 non-missing values.
}
\examples{
# Generate random samples
set.seed(108)
x <- rnorm(20); y <- rnorm(20)

# Trimmed t-test
trimmed_test(x, y, gamma = 0.1)

}
\references{
\insertRef{YueDix73appr}{robnptests}

\insertRef{Yue74trim}{robnptests}

\insertRef{Fri12onli}{robnptests}
}
