% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinAUC}
\alias{robinAUC}
\title{robinAUC}
\usage{
robinAUC(x, verbose = FALSE)
}
\arguments{
\item{x}{A robin class object. The output of the functions:
\code{\link{robinRobust}} and \code{\link{robinCompare}}.}

\item{verbose}{flag for verbose output (default as FALSE).}
}
\value{
A list
}
\description{
This function calculates the area under two curves with a spline approach.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
proc <- robinRobust(graph=graph, graphRandom=graphRandom, method="louvain",
measure="vi")
robinAUC(proc)
}
