% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN_plots.R
\name{plotMultiCompare}
\alias{plotMultiCompare}
\title{plotMultiCompare}
\usage{
plotMultiCompare(..., title = "Robin plot", ylim1 = FALSE)
}
\arguments{
\item{...}{all robin objects obtained from the comparison between one 
community detection algorithm and all the others}

\item{title}{character a title for the plot (default is "Robin plot")}

\item{ylim1}{logical for spanning the y axis from 0 to 1 (default is FALSE)}
}
\value{
a ggplot2 object
}
\description{
This function plots the curves of the measure of many community 
detection algorithms compared.
}
\examples{
\donttest{my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
comp1 <- robinCompare(graph=graph, method1="fastGreedy",method2="louvain")
comp2 <- robinCompare(graph=graph, method1="fastGreedy",method2="infomap")
plotMultiCompare(comp1,comp2)}
}
