% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.study.dissimilarities_function.R
\name{plot_study_dissimilarities}
\alias{plot_study_dissimilarities}
\title{Plot Gower's disimilarity values for each study (Transitivity evaluation)}
\usage{
plot_study_dissimilarities(
  results,
  axis_title_size = 12,
  axis_text_size = 12,
  strip_text_size = 11,
  label_size = 3.5
)
}
\arguments{
\item{results}{An object of S3 class \code{\link{comp_clustering}}.
See 'Value' in \code{\link{comp_clustering}}.}

\item{axis_title_size}{A positive integer for the font size of axis title
(both axes). \code{axis_title_size} determines the axis.title argument
found in the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{axis_text_size}{A positive integer for the font size of axis text (both
axes). \code{axis_text_size} determines the axis.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{strip_text_size}{A positive integer for the font size of facet labels.
\code{strip_text_size} determines the strip.text argument found in the
theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{label_size}{A positive integer for the font size of labels appearing on
each study-specific segment. \code{label_size} determines the size argument
found in the geom's aesthetic properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}
}
\value{
A horizontal bar plot illustrating the range of Gower's dissimilarity
values for each study with those found in other comparisons. The
study names appear on the y-axis in the order they appear in \code{results}
and the dissimilarity values appear on the x-axis. Red and blue points refer
to the (average) within-comparison and between-comparison dissimilarity,
respectively, for each study.

A data-frame on the (average) within-comparison and between-comparison
dissimilarities for each study alongside the study name and comparison.
The last two columns refer to the within-comparison and between-comparison
dissimilarities, respectively, after replacing with the maximum value in the
multi-arm trials. These two columns should be used as a covariate in the
function \code{\link{study_perc_contrib}} to obtain the
percentage contribution of each study based on the covariate values.
}
\description{
Illustrating the range of Gower's dissimilarity values for each study in the
network, as well as their between- and within-comparison dissimilarities
}
\details{
The range of Gower's dissimilarity values for each study versus the remaining
studies in the network for a set of clinical and methodological
characteristics that may act as effect modifiers. Gower's dissimilarities take
values from 0 to 1, with 0 and 1 implying perfect similarity and perfect
dissimilarity, respectively.

The unique dissimilarity values appear as dotted, vertical, grey lines on
each study
}
\examples{
\donttest{
# Fictional dataset
data_set <- data.frame(Trial_name = paste("study", as.character(1:7)),
                      arm1 = c("1", "1", "1", "1", "1", "2", "2"),
                      arm2 = c("2", "2", "2", "3", "3", "3", "3"),
                      sample = c(140, 145, 150, 40, 45, 75, 80),
                      age = c(18, 18, 18, 48, 48, 35, 35),
                      blinding = factor(c("yes", "yes", "yes", "no", "no", "no", "no")))

# Obtain comparison dissimilarities (informative = TRUE)
res <- comp_clustering(input = data_set,
                       drug_names = c("A", "B", "C"),
                       threshold = 0.13,  # General research setting
                       informative = TRUE,
                       get_plots = TRUE)

plot_study_dissimilarities(results = res,
                           axis_title_size = 12,
                           axis_text_size = 12,
                           strip_text_size = 11,
                           label_size = 3.5)
}

}
\references{
Gower J. General Coefficient of Similarity and Some of Its Properties.
\emph{Biometrics} 1971;\bold{27}(4):857--71.
doi: 10.2307/2528823
}
\seealso{
\code{\link{comp_clustering}}, \code{\link{study_perc_contrib}}
}
\author{
{Loukia M. Spineli}
}
