% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetObject.R
\name{retrieveCellFeature}
\alias{retrieveCellFeature}
\title{Retrieve a single matrix of cells from a slot}
\usage{
retrieveCellFeature(
  object,
  feature,
  slot = c("rawData", "normData", "scaleData", "H", "H.norm", "cellMeta", "rawPeak",
    "normPeak"),
  cellIdx = NULL,
  ...
)
}
\arguments{
\item{object}{\linkS4class{liger} object}

\item{feature}{Gene names, factor index or cell metadata variable names.
Should be available in specified \code{slot}.}

\item{slot}{Exactly choose from \code{"rawData"}, \code{"normData"},
\code{"scaleData"}, \code{"H"}, \code{"H.norm"} or \code{"cellMeta"}.}

\item{cellIdx}{Any valid type of index that subset from all cells. Default
\code{NULL} uses all cells.}

\item{...}{Additional arguments passed to \code{\link{subsetLiger}} when
\code{slot} is one of \code{"rawData"}, \code{"normData"} or
\code{"scaleData"}.}
}
\value{
A matrix object where rows are cells and columns are specified
features.
}
\description{
Only retrieve data from specific slot to reduce memory used by
a whole \linkS4class{liger} object of the subset. Useful for plotting.
Internally used by \code{\link{plotDimRed}} and \code{\link{plotCellViolin}}.
}
\examples{
S100A8Exp <- retrieveCellFeature(pbmc, "S100A8")
qcMetrics <- retrieveCellFeature(pbmc, c("nUMI", "nGene", "mito"),
                                 slot = "cellMeta")
}
