% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotplot.R
\name{.complexHeatmapDotPlot}
\alias{.complexHeatmapDotPlot}
\title{Generate dot plot from input matrix with ComplexHeatmap}
\usage{
.complexHeatmapDotPlot(
  colorMat,
  sizeMat,
  featureAnnDF = NULL,
  cellSplitVar = NULL,
  cellLabels = NULL,
  maxDotSize = 4,
  clusterFeature = FALSE,
  clusterCell = FALSE,
  legendColorTitle = "Matrix Value",
  legendSizeTitle = "Fraction Value",
  transpose = FALSE,
  baseSize = 8,
  cellTextSize = NULL,
  featureTextSize = NULL,
  cellTitleSize = NULL,
  featureTitleSize = NULL,
  legendTextSize = NULL,
  legendTitleSize = NULL,
  featureGrpRot = 0,
  viridisOption = "C",
  viridisDirection = -1,
  ...
)
}
\arguments{
\item{colorMat, sizeMat}{Matrix of the same size. Values in \code{colorMat}
will be visualized with color while values in \code{sizeMat} will be
reflected by dot size.}

\item{featureAnnDF}{Data frame of features containing feature names and
grouping labels.}

\item{cellSplitVar}{Split the cell orientation (default columns) by this
variable.}

\item{cellLabels}{Label to be shown on cell orientation.}

\item{maxDotSize}{The maximum dot size. Default \code{4}.}

\item{clusterFeature, clusterCell}{Whether the feature/cell orientation
(default rows/column, respectively) should be clustered. Default
\code{FALSE}.}

\item{legendColorTitle, legendSizeTitle}{The title for color bar and dot size
legends, repectively. Default see \code{"Matrix Value"} and \code{"Fraction
Value"}.}

\item{transpose}{Logical, whether to rotate the dot plot orientation. i.e.
rows as cell aggregation and columns as features. Default \code{FALSE}.}

\item{baseSize}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this. Default
\code{8}.}

\item{cellTextSize, featureTextSize, legendTextSize}{Size of cell labels,
feature label and legend text. Default \code{NULL} controls by
\code{baseSize}.}

\item{cellTitleSize, featureTitleSize, legendTitleSize}{Size of titles on
cell and feature orientation and legend title. Default \code{NULL} controls
by \code{baseSize + 2}.}

\item{featureGrpRot}{Number of degree to rotate the feature grouping label.
Default \code{0}.}

\item{viridisOption, viridisDirection}{See argument \code{option} and
\code{direction} of \code{\link[viridis]{viridis}}. Default \code{"A"}
and \code{-1}.}

\item{...}{Additional arguments passed to
\code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
A \code{\link[ComplexHeatmap]{HeatmapList}} object.
}
\description{
Generate dot plot from input matrix with ComplexHeatmap
}
