% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{alpha_hat}
\alias{alpha_hat}
\title{Statistical estimator for alpha}
\usage{
alpha_hat(t1, t2, k, path, H, freq)
}
\arguments{
\item{t1, t2}{real number such that  t2 > t1 > 0}

\item{k}{increment order}

\item{path}{sample path of lfsm on which the inference is to be performed}

\item{H}{Hurst parameter}

\item{freq}{Frequency of the motion. It can take two values: "H" for high frequency and "L" for the low frequency setting.}
}
\description{
Defined for the two frequencies as
\deqn{\widehat \alpha_{high} := \frac{\log | \log \varphi_{high} (t_2; \widehat H_{high} (p,k)_n, k)_n|  -  \log | \log \varphi_{high} (t_1; \widehat H_{high} (p,k)_n, k)_n|}{\log t_2 - \log t_1}}
\deqn{\widehat \alpha_{low} := \frac{\log | \log \varphi_{low} (t_2;k)_n|  -  \log | \log \varphi_{low} (t_1; k)_n|}{\log t_2 - \log t_1}}
}
\details{
The function triggers function \code{\link{phi}}, thus Hurst parameter is required only in high frequency case. In the low frequency, there is no need to assign H a value because it will not be evaluated.
}
\examples{

m<-45; M<-60; N<-2^14-M
alpha<-1.8; H<-0.8; sigma<-0.3
freq='H'
r=1; k=2; p=0.4; t1=1; t2=2

# Estimating alpha in the high frequency case
# using preliminary estimation of H
lfsm<-path(N=N,m=m,M=M,alpha=alpha,H=H,
           sigma=sigma,freq='L',disable_X=FALSE,seed=3)$lfsm

H_est<-H_hat(p=p,k=k,path=lfsm)
H_est
alpha_est<-alpha_hat(t1=t1,t2=t2,k=k,path=lfsm,H=H_est,freq=freq)
alpha_est

}
\references{
\insertRef{MOP18}{rlfsm}
}
