% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{to_ts}
\alias{to_ts}
\title{Creates a time series object}
\usage{
to_ts(source, id, type = "All")
}
\arguments{
\item{source}{Source of the time series}

\item{id}{Identifier of the time series (source-dependent)}

\item{type}{Type of the requested information (Data, Metadata...).
All by default.}
}
\value{
An object of type "JD3_TS". List containing the identifiers,
the data and the metadata
}
\description{
Creates a time series object
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
source <- "Txt"
# id is split due to length restrictions
id1 <- "demetra://tsprovider/Txt/20111201/SERIES?datePattern=dd\%2FMM\%2Fyyyy&delimiter=SEMICOLON&"
id2 <- "file=C\%3A\%5CDocuments\%5CIPI\%5CData\%5CIPI_nace4.csv#seriesIndex=0"
id <- paste0(id1, id2)

to_ts(source, id)
\dontshow{\}) # examplesIf}
}
