% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_regular.R
\name{statisticaltest}
\alias{statisticaltest}
\alias{print.JD3_TEST}
\title{Generic Function For 'JDemetra+' Tests}
\usage{
statisticaltest(val, pval, dist = NULL)

\method{print}{JD3_TEST}(x, details = FALSE, ...)
}
\arguments{
\item{val, pval, dist}{statistical parameters.}

\item{x}{the object to print.}

\item{details}{boolean indicating if the statistical distribution should be printed.}

\item{...}{further arguments (ignored).}
}
\value{
\code{c("JD3_TEST", "JD3")} object that is a list of three parameters:
\itemize{
\item{\code{value}} the statistical value of the test.
\item{\code{pvalue}} the p-value of the test.
\item{\code{distribution}} the statistical distribution used.
}
}
\description{
Generic function to format the results of 'JDemetra+' tests.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
udr_test <- testofupdownruns(random_t(5, 1000))
udr_test # default print
print(udr_test, details = TRUE) # with the distribution

test <- statisticaltest(val = 45, pval = 0.1)
print(test)
\dontshow{\}) # examplesIf}
}
