% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_seasonality.R
\name{seasonality_canovahansen}
\alias{seasonality_canovahansen}
\title{Canova-Hansen seasonality test}
\usage{
seasonality_canovahansen(
  data,
  period,
  type = c("Contrast", "Dummy", "Trigonometric"),
  lag1 = TRUE,
  kernel = c("Bartlett", "Square", "Welch", "Tukey", "Hamming", "Parzen"),
  order = NA,
  start = 1
)
}
\arguments{
\item{data}{the input data.}

\item{period}{Tested periodicity. Can be missing if the input is a time series}

\item{type}{Trigonometric variables, seasonal dummies or seasonal contrasts.}

\item{lag1}{Lagged variable in the regression model.}

\item{kernel}{Kernel used to compute the robust Newey-West covariance matrix.}

\item{order}{The truncation parameter used to compute the robust Newey-West covariance matrix.}

\item{start}{Position of the first observation of the series}
}
\value{
list with the FTest on seasonal variables, the joint test and the details for the stability of the different seasonal variables
}
\description{
Canova-Hansen seasonality test
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
s <- log(ABS$X0.2.20.10.M)
seasonality_canovahansen(s, 12, type = "Contrast")
seasonality_canovahansen(s, 12, type = "Trigonometric")
\dontshow{\}) # examplesIf}
}
