% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_regular.R
\name{normality_tests}
\alias{normality_tests}
\alias{bowmanshenton}
\alias{doornikhansen}
\alias{jarquebera}
\alias{skewness}
\alias{kurtosis}
\title{Normality Tests}
\usage{
bowmanshenton(data)

doornikhansen(data)

jarquebera(data, k = 0, sample = TRUE)

skewness(data)

kurtosis(data)
}
\arguments{
\item{data}{data being tested.}

\item{k}{number of degrees of freedom to be subtracted if the input time series is a series of residuals.}

\item{sample}{boolean indicating if unbiased empirical moments should be computed.}
}
\value{
A \code{c("JD3_TEST", "JD3")} object (see \code{\link{statisticaltest}} for details).
}
\description{
Set of functions to test the normality of a time series.
}
\section{Functions}{
\itemize{
\item \code{bowmanshenton()}: Bowman-Shenton test

\item \code{doornikhansen()}: Doornik-Hansen test

\item \code{jarquebera()}: Jarque-Bera test

\item \code{skewness()}: Skewness test

\item \code{kurtosis()}: Kurtosis test

}}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
x <- rnorm(100) # null
bowmanshenton(x)
doornikhansen(x)
jarquebera(x)
skewness(x)
kurtosis(x)

x <- random_t(2, 100) # alternative
bowmanshenton(x)
doornikhansen(x)
jarquebera(x)
skewness(x)
kurtosis(x)
\dontshow{\}) # examplesIf}
}
