/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.protobuf.toolkit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Iterables;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParameterType;
import jdplus.toolkit.base.api.data.ParametersEstimation;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseLikelihoodStatistics;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.stats.tests.NiidTests;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import lombok.Generated;
import lombok.NonNull;

public final class ToolkitProtosUtility {
    private static final Parameter[] EMPTY_P = new Parameter[0];

    public static ToolkitProtos.Date convert(LocalDate ld) {
        if (ld.equals(LocalDate.MIN)) {
            return ToolkitProtos.Date.newBuilder().setYear(1).setMonth(1).setDay(1).build();
        }
        if (ld.equals(LocalDate.MAX)) {
            return ToolkitProtos.Date.newBuilder().setYear(9999).setMonth(12).setDay(31).build();
        }
        return ToolkitProtos.Date.newBuilder().setYear(ld.getYear()).setMonth(ld.getMonthValue()).setDay(ld.getDayOfMonth()).build();
    }

    public static LocalDate convert(ToolkitProtos.Date d) {
        switch (d.getYear()) {
            case 0: {
                throw new IllegalArgumentException("Date not correctly initialized");
            }
            case 1: {
                return LocalDate.MIN;
            }
            case 9999: {
                return LocalDate.MAX;
            }
        }
        return LocalDate.of(d.getYear(), d.getMonth(), d.getDay());
    }

    public static TimeSelector convert(ToolkitProtos.TimeSelector sel) {
        switch (sel.getType()) {
            case SPAN_ALL: {
                return TimeSelector.all();
            }
            case SPAN_FROM: {
                LocalDate ld = ToolkitProtosUtility.convert(sel.getD0());
                return TimeSelector.from((LocalDateTime)ld.atStartOfDay());
            }
            case SPAN_TO: {
                LocalDate ld = ToolkitProtosUtility.convert(sel.getD1());
                return TimeSelector.to((LocalDateTime)ld.atStartOfDay());
            }
            case SPAN_BETWEEN: {
                LocalDate ld0 = ToolkitProtosUtility.convert(sel.getD0());
                LocalDate ld1 = ToolkitProtosUtility.convert(sel.getD1());
                return TimeSelector.between((LocalDateTime)ld0.atStartOfDay(), (LocalDateTime)ld1.atStartOfDay());
            }
            case SPAN_FIRST: {
                int n0 = sel.getN0();
                return TimeSelector.first((int)n0);
            }
            case SPAN_LAST: {
                int n1 = sel.getN1();
                return TimeSelector.last((int)n1);
            }
            case SPAN_EXCLUDING: {
                int n0 = sel.getN0();
                int n1 = sel.getN1();
                return TimeSelector.excluding((int)n0, (int)n1);
            }
        }
        return TimeSelector.none();
    }

    public static void fill(TimeSelector sel, ToolkitProtos.TimeSelector.Builder builder) {
        switch (sel.getType()) {
            case All: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_ALL);
                break;
            }
            case From: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_FROM).setD0(ToolkitProtosUtility.convert(sel.getD0().toLocalDate()));
                break;
            }
            case To: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_TO).setD1(ToolkitProtosUtility.convert(sel.getD1().toLocalDate()));
                break;
            }
            case Between: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_BETWEEN).setD0(ToolkitProtosUtility.convert(sel.getD0().toLocalDate())).setD1(ToolkitProtosUtility.convert(sel.getD1().toLocalDate()));
                break;
            }
            case First: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_FIRST).setN0(sel.getN0());
                break;
            }
            case Last: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_LAST).setN1(sel.getN1());
                break;
            }
            case Excluding: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_EXCLUDING).setN0(sel.getN0()).setN1(sel.getN1());
                break;
            }
            default: {
                builder.setType(ToolkitProtos.SelectionType.SPAN_NONE);
            }
        }
    }

    public static ToolkitProtos.TimeSelector convert(TimeSelector sel) {
        ToolkitProtos.TimeSelector.Builder builder = ToolkitProtos.TimeSelector.newBuilder();
        ToolkitProtosUtility.fill(sel, builder);
        return builder.build();
    }

    public static ParameterType convert(ToolkitProtos.ParameterType t) {
        switch (t) {
            case PARAMETER_FIXED: {
                return ParameterType.Fixed;
            }
            case PARAMETER_INITIAL: {
                return ParameterType.Initial;
            }
            case PARAMETER_ESTIMATED: {
                return ParameterType.Estimated;
            }
            case PARAMETER_UNDEFINED: {
                return ParameterType.Undefined;
            }
        }
        return null;
    }

    public static ToolkitProtos.ParameterType convert(@NonNull ParameterType t) {
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        switch (t) {
            case Fixed: {
                return ToolkitProtos.ParameterType.PARAMETER_FIXED;
            }
            case Initial: {
                return ToolkitProtos.ParameterType.PARAMETER_INITIAL;
            }
            case Estimated: {
                return ToolkitProtos.ParameterType.PARAMETER_ESTIMATED;
            }
        }
        return ToolkitProtos.ParameterType.PARAMETER_UNDEFINED;
    }

    public static Parameter convert(ToolkitProtos.Parameter p) {
        switch (p.getType()) {
            case PARAMETER_FIXED: {
                return Parameter.fixed((double)p.getValue());
            }
            case PARAMETER_INITIAL: {
                return Parameter.initial((double)p.getValue());
            }
            case PARAMETER_ESTIMATED: {
                return Parameter.estimated((double)p.getValue());
            }
            case PARAMETER_UNDEFINED: {
                return Parameter.undefined();
            }
        }
        return null;
    }

    public static ToolkitProtos.Parameter convert(Parameter p) {
        if (p == null) {
            return ToolkitProtos.Parameter.getDefaultInstance();
        }
        return ToolkitProtos.Parameter.newBuilder().setType(ToolkitProtosUtility.convert(p.getType())).setValue(p.getValue()).build();
    }

    public static List<ToolkitProtos.Parameter> convert(Parameter[] p) {
        if (p == null || p.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ToolkitProtos.Parameter> list = new ArrayList<ToolkitProtos.Parameter>();
        for (int i = 0; i < p.length; ++i) {
            list.add(ToolkitProtosUtility.convert(p[i]));
        }
        return list;
    }

    public static ToolkitProtos.ParametersEstimation convert(@NonNull ParametersEstimation p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        ToolkitProtos.ParametersEstimation.Builder builder = ToolkitProtos.ParametersEstimation.newBuilder().addAllValue(Iterables.of((DoubleSeq)p.getValues())).addAllScore(Iterables.of((DoubleSeq)p.getScores())).setCovariance(ToolkitProtosUtility.convert(p.getCovariance()));
        String description = p.getDescription();
        if (description != null) {
            builder.setDescription(description);
        }
        return builder.build();
    }

    public static ToolkitProtos.Parameter convert(@NonNull Parameter p, String description) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        return ToolkitProtos.Parameter.newBuilder().setType(ToolkitProtosUtility.convert(p.getType())).setValue(p.getValue()).setDescription(description).build();
    }

    public static Parameter[] convert(List<ToolkitProtos.Parameter> p) {
        int n = p.size();
        if (n == 0) {
            return null;
        }
        Parameter[] np = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            Parameter c = ToolkitProtosUtility.convert(p.get(i));
            np[i] = c == null ? Parameter.undefined() : c;
        }
        return np;
    }

    public static TsData convert(ToolkitProtos.TsData s) {
        int p = s.getAnnualFrequency();
        int y = s.getStartYear();
        int m = s.getStartPeriod();
        int n = s.getValuesCount();
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = s.getValues(i);
        }
        return ToolkitProtosUtility.ts(p, y, m, data);
    }

    public static ToolkitProtos.TsData convert(TsData s) {
        if (s == null || s.isEmpty()) {
            return ToolkitProtos.TsData.getDefaultInstance();
        }
        TsPeriod start = s.getStart();
        return ToolkitProtos.TsData.newBuilder().setAnnualFrequency(s.getAnnualFrequency()).setStartYear(start.year()).setStartPeriod(start.annualPosition() + 1).addAllValues(Iterables.of((DoubleSeq)s.getValues())).build();
    }

    public static ToolkitProtos.TsData convert(TsData s, String name) {
        if (s == null || s.isEmpty()) {
            return ToolkitProtos.TsData.getDefaultInstance().toBuilder().setName(name).build();
        }
        TsPeriod start = s.getStart();
        return ToolkitProtos.TsData.newBuilder().setAnnualFrequency(s.getAnnualFrequency()).setStartYear(start.year()).setStartPeriod(start.annualPosition() + 1).addAllValues(Iterables.of((DoubleSeq)s.getValues())).setName(name).build();
    }

    public static ToolkitProtos.TsMoniker convert(TsMoniker moniker) {
        return ToolkitProtos.TsMoniker.newBuilder().setSource(moniker.getSource()).setId(moniker.getId()).build();
    }

    public static TsMoniker convert(ToolkitProtos.TsMoniker moniker) {
        return TsMoniker.of((String)moniker.getSource(), (String)moniker.getId());
    }

    public static ToolkitProtos.Ts convert(Ts s) {
        if (s == null) {
            return ToolkitProtos.Ts.getDefaultInstance();
        }
        return ToolkitProtos.Ts.newBuilder().setName(s.getName()).setMoniker(ToolkitProtosUtility.convert(s.getMoniker())).setData(ToolkitProtosUtility.convert(s.getData())).putAllMetadata(s.getMeta()).build();
    }

    public static ToolkitProtos.TsCollection convert(TsCollection s) {
        if (s == null) {
            return ToolkitProtos.TsCollection.getDefaultInstance();
        }
        return ToolkitProtos.TsCollection.newBuilder().setName(s.getName()).setMoniker(ToolkitProtosUtility.convert(s.getMoniker())).putAllMetadata(s.getMeta()).addAllSeries(s.getItems().stream().map(t -> ToolkitProtosUtility.convert(t)).toList()).build();
    }

    public static Ts convert(ToolkitProtos.Ts s) {
        if (s == null) {
            return null;
        }
        return Ts.builder().name(s.getName()).moniker(ToolkitProtosUtility.convert(s.getMoniker())).data(ToolkitProtosUtility.convert(s.getData())).meta(s.getMetadataMap()).build();
    }

    public static TsCollection convert(ToolkitProtos.TsCollection s) {
        if (s == null) {
            return null;
        }
        return TsCollection.builder().name(s.getName()).moniker(ToolkitProtosUtility.convert(s.getMoniker())).meta(s.getMetadataMap()).items(s.getSeriesList().stream().map(t -> ToolkitProtosUtility.convert(t)).toList()).build();
    }

    public static ToolkitProtos.Matrix convert(Matrix m) {
        if (m == null || m.isEmpty()) {
            return ToolkitProtos.Matrix.getDefaultInstance();
        }
        return ToolkitProtos.Matrix.newBuilder().setNrows(m.getRowsCount()).setNcols(m.getColumnsCount()).addAllValues(Iterables.of((double[])m.toArray())).build();
    }

    public static ToolkitProtos.LikelihoodStatistics convert(LikelihoodStatistics ls) {
        return ToolkitProtos.LikelihoodStatistics.newBuilder().setNobs(ls.getObservationsCount()).setNeffectiveobs(ls.getEffectiveObservationsCount()).setNparams(ls.getEstimatedParametersCount()).setDegreesOfFreedom(ls.getEffectiveObservationsCount() - ls.getEstimatedParametersCount()).setLogLikelihood(ls.getLogLikelihood()).setAdjustedLogLikelihood(ls.getAdjustedLogLikelihood()).setAic(ls.getAIC()).setAicc(ls.getAICC()).setBic(ls.getBIC()).setBicc(ls.getBICC()).setBic2(ls.getBIC2()).setHannanQuinn(ls.getHannanQuinn()).setSsq(ls.getSsqErr()).build();
    }

    public static ToolkitProtos.DiffuseLikelihoodStatistics convert(DiffuseLikelihoodStatistics ls) {
        return ToolkitProtos.DiffuseLikelihoodStatistics.newBuilder().setNobs(ls.getObservationsCount()).setNdiffuse(ls.getDiffuseCount()).setNparams(ls.getEstimatedParametersCount()).setDegreesOfFreedom(ls.getObservationsCount() - ls.getDiffuseCount() - ls.getEstimatedParametersCount()).setLogLikelihood(ls.getLogLikelihood()).setAdjustedLogLikelihood(ls.getAdjustedLogLikelihood()).setAic(ls.aic()).setAicc(ls.aicc()).setBic(ls.bic()).setSsq(ls.getSsqErr()).setLdet(ls.getLogDeterminant()).setDcorrection(ls.getDiffuseCorrection()).build();
    }

    public static ModellingProtos.ArimaModel convert(IArimaModel arima, String name) {
        if (arima == null) {
            return ModellingProtos.ArimaModel.getDefaultInstance();
        }
        return ModellingProtos.ArimaModel.newBuilder().addAllAr(Iterables.of((DoubleSeq)arima.getStationaryAr().asPolynomial().coefficients())).addAllDelta(Iterables.of((DoubleSeq)arima.getNonStationaryAr().asPolynomial().coefficients())).addAllMa(Iterables.of((DoubleSeq)arima.getMa().asPolynomial().coefficients())).setInnovationVariance(arima.getInnovationVariance()).setName(name).build();
    }

    public static ToolkitProtos.StatisticalTest convert(StatisticalTest test) {
        if (test == null) {
            return ToolkitProtos.StatisticalTest.getDefaultInstance();
        }
        return ToolkitProtos.StatisticalTest.newBuilder().setValue(test.getValue()).setPvalue(test.getPvalue()).setDescription(test.getDescription()).build();
    }

    public static ToolkitProtos.OneWayAnova convert(OneWayAnova anova) {
        return ToolkitProtos.OneWayAnova.newBuilder().setSSM(anova.getSsm()).setDfm(anova.getDfm()).setSSR(anova.getSsr()).setDfr(anova.getDfr()).build();
    }

    public static ToolkitProtos.NIIDTests convert(NiidTests tests) {
        if (tests == null) {
            return ToolkitProtos.NIIDTests.getDefaultInstance();
        }
        return ToolkitProtos.NIIDTests.newBuilder().setMean(ToolkitProtosUtility.convert(tests.meanTest())).setSkewness(ToolkitProtosUtility.convert(tests.skewness())).setKurtosis(ToolkitProtosUtility.convert(tests.kurtosis())).setDoornikHansen(ToolkitProtosUtility.convert(tests.normalityTest())).setBoxPierce(ToolkitProtosUtility.convert(tests.boxPierce())).setLjungBox(ToolkitProtosUtility.convert(tests.ljungBox())).setSeasonalBoxPierce(ToolkitProtosUtility.convert(tests.seasonalBoxPierce())).setSeasonalLjungBox(ToolkitProtosUtility.convert(tests.seasonalLjungBox())).setRunsNumber(ToolkitProtosUtility.convert(tests.runsNumber())).setRunsLength(ToolkitProtosUtility.convert(tests.runsLength())).setUpDownRunsNumber(ToolkitProtosUtility.convert(tests.upAndDownRunsNumbber())).setUpDownRunsLength(ToolkitProtosUtility.convert(tests.upAndDownRunsLength())).setBoxPierceOnSquares(ToolkitProtosUtility.convert(tests.boxPierceOnSquare())).setLjungBoxOnSquares(ToolkitProtosUtility.convert(tests.ljungBoxOnSquare())).build();
    }

    static TsData ts(int freq, int year, int start, double[] data) {
        switch (freq) {
            case 1: {
                return TsData.ofInternal((TsPeriod)TsPeriod.yearly((int)year), (double[])data);
            }
            case 12: {
                return TsData.ofInternal((TsPeriod)TsPeriod.monthly((int)year, (int)start), (double[])data);
            }
        }
        int c = 12 / freq;
        TsPeriod pstart = TsPeriod.of((TsUnit)TsUnit.ofAnnualFrequency((int)freq), (LocalDate)LocalDate.of(year, (start - 1) * c + 1, 1));
        return TsData.ofInternal((TsPeriod)pstart, (double[])data);
    }

    @Generated
    private ToolkitProtosUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

