/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.ar.AutoRegressiveEstimation;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class PeriodicLjungBox {
    private int[] lags;
    private int nhp;
    private int sign;
    private final IntToDoubleFunction autoCorrelations;
    private final int n;

    public PeriodicLjungBox(DoubleSeq sample, int nar) {
        if (nar > 0) {
            AutoRegressiveEstimation burg = AutoRegressiveEstimation.burg();
            burg.estimate(sample, nar);
            this.autoCorrelations = AutoCovariances.autoCorrelationFunction((DoubleSeq)burg.residuals(), (double)0.0);
        } else {
            this.autoCorrelations = AutoCovariances.autoCorrelationFunction((DoubleSeq)sample, (double)0.0);
        }
        this.n = sample.length();
    }

    public PeriodicLjungBox hyperParametersCount(int nhp) {
        this.nhp = nhp;
        return this;
    }

    public PeriodicLjungBox useNegativeAutocorrelations() {
        this.sign = -1;
        return this;
    }

    public PeriodicLjungBox usePositiveAutocorrelations() {
        this.sign = 1;
        return this;
    }

    public PeriodicLjungBox useAllAutocorrelations() {
        this.sign = 0;
        return this;
    }

    public PeriodicLjungBox lags(int[] value) {
        this.lags = value;
        return this;
    }

    public PeriodicLjungBox lags(double period, int nperiods) {
        this.lags = new int[nperiods];
        for (int i = 1; i <= nperiods; ++i) {
            double ip = period * (double)i + 0.5;
            this.lags[i - 1] = (int)ip;
        }
        return this;
    }

    public int[] getLags() {
        return this.lags;
    }

    public StatisticalTest build() {
        if (this.lags == null) {
            throw new StatException("Invalid lags in LjungBox test");
        }
        double res = 0.0;
        for (int i = 0; i < this.lags.length; ++i) {
            double ai = this.autoCorrelations.applyAsDouble(this.lags[i]);
            if (!(this.sign == 0 || this.sign == 1 && ai > 0.0) && (this.sign != -1 || !(ai < 0.0))) continue;
            res += ai * ai / (double)(this.n - this.lags[i]);
        }
        double val = res * (double)this.n * (double)(this.n + 2);
        Chi2 chi = new Chi2(this.lags.length > this.nhp ? (double)this.lags.length : (double)(this.lags.length - this.nhp));
        return TestsUtility.testOf((double)val, (ContinuousDistribution)chi, (TestType)TestType.Upper);
    }
}

