/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicContrasts;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.PeriodicContrastsFactory;
import jdplus.toolkit.base.core.stats.linearmodel.JointTest;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class FTest {
    private SarimaOrders.Prespecified model = SarimaOrders.Prespecified.WN;
    private final DoubleSeq s;
    private final int period;
    private int ncycles;

    public FTest(DoubleSeq s, int period) {
        this.s = s;
        this.period = period;
    }

    public FTest model(SarimaOrders.Prespecified model) {
        this.model = model;
        return this;
    }

    public FTest ncycles(int n) {
        this.ncycles = n;
        return this;
    }

    public StatisticalTest build() {
        if (this.period <= 1) {
            throw new IllegalArgumentException("Invalid periodicity");
        }
        switch (this.model) {
            case AR: {
                return this.processAr();
            }
            case D1: {
                return this.processDiff();
            }
            case WN: {
                return this.process();
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private StatisticalTest process() {
        DoubleSeq y = this.ncycles == 0 ? this.s : this.s.drop(Math.max(0, this.s.length() - this.ncycles * this.period), 0);
        try {
            PeriodicContrasts dummies = new PeriodicContrasts(this.period);
            FastMatrix matrix = PeriodicContrastsFactory.matrix((PeriodicContrasts)dummies, (int)y.length(), (int)0);
            double ybar = y.average();
            LinearModel reg = LinearModel.builder().y(y.fn(q -> q - ybar)).addX((Matrix)matrix).build();
            int nseas = dummies.dim();
            LeastSquaresResults lsr = Ols.compute((LinearModel)reg);
            return new JointTest(lsr.getLikelihood()).variableSelection(0, nseas).blue().build();
        }
        catch (Exception err) {
            return null;
        }
    }

    private StatisticalTest processAr() {
        DoubleSeq y = this.ncycles == 0 ? this.s : this.s.drop(Math.max(0, this.s.length() - this.ncycles * this.period - 1), 0);
        try {
            PeriodicContrasts dummies = new PeriodicContrasts(this.period);
            FastMatrix matrix = PeriodicContrastsFactory.matrix((PeriodicContrasts)dummies, (int)(y.length() - 1), (int)0);
            LinearModel reg = LinearModel.builder().y(y.drop(1, 0)).meanCorrection(true).addX(y.drop(0, 1)).addX((Matrix)matrix).build();
            int nseas = dummies.dim();
            LeastSquaresResults lsr = Ols.compute((LinearModel)reg);
            return new JointTest(lsr.getLikelihood()).variableSelection(2, nseas).blue().build();
        }
        catch (Exception err) {
            return null;
        }
    }

    private StatisticalTest processDiff() {
        DoubleSeq y = this.ncycles == 0 ? this.s : this.s.drop(Math.max(0, this.s.length() - this.ncycles * this.period - 1), 0);
        DoubleSeq dy = y.delta(1);
        try {
            PeriodicContrasts dummies = new PeriodicContrasts(this.period);
            FastMatrix matrix = PeriodicContrastsFactory.matrix((PeriodicContrasts)dummies, (int)dy.length(), (int)0);
            double dybar = dy.average();
            LinearModel reg = LinearModel.builder().y(dy.fn(q -> q - dybar)).addX((Matrix)matrix).build();
            int nseas = dummies.dim();
            LeastSquaresResults lsr = Ols.compute((LinearModel)reg);
            return new JointTest(lsr.getLikelihood()).variableSelection(0, nseas).blue().build();
        }
        catch (Exception err) {
            return null;
        }
    }
}

