/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.analysis.TrigonometricSeries;
import jdplus.toolkit.base.core.data.analysis.WindowFunction;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.RobustCovarianceComputer;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class CanovaHansen2 {
    private final DoubleSeq s;
    private boolean trend = false;
    private double period;
    private WindowFunction winFunction = WindowFunction.Bartlett;
    private int truncationLag = 12;
    private boolean lag1 = true;

    public static CanovaHansen2 of(DoubleSeq s) {
        return new CanovaHansen2(s);
    }

    private CanovaHansen2(DoubleSeq s) {
        this.s = s;
    }

    public CanovaHansen2 periodicity(double period) {
        this.period = period;
        return this;
    }

    public CanovaHansen2 lag1(boolean lag1) {
        this.lag1 = lag1;
        return this;
    }

    public CanovaHansen2 trend(boolean trend) {
        this.trend = trend;
        return this;
    }

    public CanovaHansen2 truncationLag(int truncationLag) {
        this.truncationLag = truncationLag;
        return this;
    }

    public CanovaHansen2 windowFunction(WindowFunction winFunction) {
        this.winFunction = winFunction;
        return this;
    }

    public double compute() {
        FastMatrix x = this.sx();
        LinearModel lm = this.buildModel(x);
        LeastSquaresResults olsResults = Ols.compute((LinearModel)lm);
        DataBlock e = lm.calcResiduals(olsResults.getCoefficients());
        double rvar = RobustCovarianceComputer.covariance((DoubleSeq)e, (WindowFunction)this.winFunction, (int)this.truncationLag);
        int n = lm.getObservationsCount();
        FastMatrix xe = this.lag1 ? x.extract(1, n, 0, x.getColumnsCount()) : x;
        xe.applyByColumns(arg_0 -> CanovaHansen2.lambda$compute$1((DoubleSeq)e, arg_0));
        xe.applyByColumns(c -> c.cumul());
        if (xe.getColumnsCount() == 1) {
            return xe.column(0).ssq() / ((double)(n * n) * rvar);
        }
        return 2.0 * (xe.column(0).ssq() + xe.column(1).ssq()) / ((double)(n * n) * rvar);
    }

    private FastMatrix sx() {
        int len = this.s.length();
        TrigonometricSeries vars = TrigonometricSeries.specific((double)this.period);
        return vars.matrix(len, 0);
    }

    private LinearModel buildModel(FastMatrix sx) {
        if (!this.lag1) {
            LinearModel.Builder builder = LinearModel.builder();
            builder.y(this.s);
            if (this.trend) {
                builder.addX(DoubleSeq.onMapping((int)this.s.length(), i -> i));
            }
            builder.addX((Matrix)sx).meanCorrection(true);
            return builder.build();
        }
        LinearModel.Builder builder = LinearModel.builder();
        builder.y(this.s.drop(1, 0)).addX(this.s.drop(0, 1)).meanCorrection(true);
        if (this.trend) {
            builder.addX(DoubleSeq.onMapping((int)this.s.length(), i -> i));
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$compute$1(DoubleSeq e, DataBlock c) {
        c.apply(e, (a, b) -> a * b);
    }
}

