/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.regarima;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdplus.sa.base.api.ComponentType;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.modelling.regular.CalendarSpec;
import jdplus.toolkit.base.api.modelling.regular.EasterSpec;
import jdplus.toolkit.base.api.modelling.regular.MeanSpec;
import jdplus.toolkit.base.api.modelling.regular.ModellingSpec;
import jdplus.toolkit.base.api.modelling.regular.RegressionSpec;
import jdplus.toolkit.base.api.modelling.regular.TradingDaysSpec;
import jdplus.toolkit.base.api.modelling.regular.TransformSpec;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarManager;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.EasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.HolidaysCorrectedTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.JulianEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.LengthOfPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.StockTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.TsContextVariable;
import jdplus.toolkit.base.api.timeseries.regression.UserTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.data.interpolation.AverageInterpolator;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.HolidaysCorrectionFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.TransitoryChangeFactory;
import jdplus.toolkit.base.core.regsarima.regular.IModelBuilder;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataToolkit;
import lombok.NonNull;

public class ModelBuilder
implements IModelBuilder {
    public static final Map<String, String> calendarAMI;
    private final ModellingSpec spec;
    private final ModellingContext context;

    public ModelBuilder(ModellingSpec spec, ModellingContext context) {
        this.spec = spec;
        this.context = context != null ? context : ModellingContext.getActiveContext();
    }

    private void initializeArima(ModelDescription model) {
        int freq = model.getAnnualFrequency();
        model.setArimaSpec(this.spec.getArima().withPeriod(freq));
    }

    private void initializeVariables(ModelDescription model, RegressionSpec regSpec) {
        if (!regSpec.isUsed()) {
            return;
        }
        this.initializeMean(model, regSpec.getMean());
        this.initializeCalendar(model, regSpec.getCalendar());
        this.initializeOutliers(model, regSpec.getOutliers());
        this.initializeUsers(model, regSpec.getUserDefinedVariables());
        this.initializeInterventions(model, regSpec.getInterventionVariables());
        this.initializeRamps(model, regSpec.getRamps());
    }

    public ModelDescription build(TsData series, ProcessingLog log) {
        TsData nseries = TsDataToolkit.select((TsData)series, (TimeSelector)this.spec.getSeries().getSpan());
        TsDomain edom = nseries.getDomain().select(this.spec.getEstimate().getSpan());
        ModelDescription cur = new ModelDescription(nseries, edom);
        this.initializeMissing(cur);
        this.initializeTransformation(cur, this.spec.getTransform());
        this.initializeVariables(cur, this.spec.getRegression());
        this.initializeArima(cur);
        return cur;
    }

    private void initializeMissing(ModelDescription cur) {
        cur.interpolate(AverageInterpolator.interpolator());
    }

    private void initializeTransformation(ModelDescription model, TransformSpec fnSpec) {
        if (fnSpec.getFunction() == TransformationType.Log) {
            model.setLogTransformation(true);
        }
        model.setPreadjustment(fnSpec.getAdjust());
    }

    private void initializeMean(ModelDescription model, MeanSpec mu) {
        if (!mu.isUsed()) {
            model.setMean(false);
        } else if (Parameter.isFixed((Parameter)mu.getCoefficient())) {
            int d = this.spec.getArima().getD();
            int bd = this.spec.getArima().getBd();
            this.add(model, (ITsVariable)new TrendConstant(d, bd, model.getEstimationDomain().start()), "const", ComponentType.Undefined, new Parameter[]{mu.getCoefficient()});
            model.setMean(false);
        } else {
            model.setMean(true);
        }
    }

    private void initializeCalendar(ModelDescription model, CalendarSpec calendar) {
        this.initializeTradingDays(model, calendar.getTradingDays());
        this.initializeEaster(model, calendar.getEaster());
    }

    private void initializeTradingDays(ModelDescription model, TradingDaysSpec td) {
        if (!td.isUsed() || td.isTest() || td.isAutomatic()) {
            return;
        }
        if (td.isStockTradingDays()) {
            this.initializeStockTradingDays(model, td);
        } else if (td.getHolidays() != null) {
            this.initializeHolidays(model, td);
        } else if (td.getUserVariables() != null) {
            this.initializeUserTradingDays(model, td);
        } else {
            this.initializeDefaultTradingDays(model, td);
        }
    }

    private void initializeEaster(ModelDescription model, EasterSpec easter) {
        if (!easter.isUsed() || easter.isTest()) {
            return;
        }
        this.add(model, (ITsVariable)ModelBuilder.easter(this.spec), "easter", ComponentType.CalendarEffect, easter.getCoefficient());
    }

    private void initializeOutliers(ModelDescription model, List<Variable<IOutlier>> outliers) {
        int freq = model.getAnnualFrequency();
        TransitoryChangeFactory tc = new TransitoryChangeFactory(this.spec.getOutliers().getDeltaTC());
        PeriodicOutlierFactory so = new PeriodicOutlierFactory(freq, true);
        for (Variable<IOutlier> outlier : outliers) {
            AdditiveOutlier v;
            IOutlier cur = (IOutlier)outlier.getCore();
            String code = cur.getCode();
            LocalDateTime pos = cur.getPosition();
            ComponentType cmp = ComponentType.Undefined;
            switch (code) {
                case "AO": {
                    v = AdditiveOutlierFactory.FACTORY.make(pos);
                    cmp = ComponentType.Irregular;
                    break;
                }
                case "LS": {
                    v = LevelShiftFactory.FACTORY_ZEROENDED.make(pos);
                    cmp = ComponentType.Trend;
                    break;
                }
                case "SO": {
                    v = so.make(pos);
                    cmp = ComponentType.Seasonal;
                    break;
                }
                case "TC": {
                    v = tc.make(pos);
                    cmp = ComponentType.Irregular;
                    break;
                }
                default: {
                    v = null;
                }
            }
            if (v == null) continue;
            Variable nvar = outlier.withCore((ITsVariable)v);
            if (!nvar.hasAttribute("regeffect")) {
                nvar = nvar.setAttribute("regeffect", cmp.name());
            }
            model.addVariable(nvar);
        }
    }

    private void initializeUsers(ModelDescription model, List<Variable<TsContextVariable>> uvars) {
        for (Variable<TsContextVariable> user : uvars) {
            String name = user.getName();
            ITsVariable var = ((TsContextVariable)user.getCore()).instantiateFrom(this.context, name);
            model.addVariable(user.withCore(var));
        }
    }

    private void initializeInterventions(ModelDescription model, List<Variable<InterventionVariable>> interventionVariables) {
        for (Variable<InterventionVariable> iv : interventionVariables) {
            model.addVariable(iv);
        }
    }

    private void initializeRamps(ModelDescription model, List<Variable<Ramp>> ramps) {
        for (Variable<Ramp> r : ramps) {
            model.addVariable(r);
        }
    }

    private void initializeHolidays(ModelDescription model, TradingDaysSpec td) {
        this.add(model, (ITsVariable)ModelBuilder.holidays(td, this.context), "td", ComponentType.CalendarEffect, td.getTdCoefficients());
        this.add(model, (ITsVariable)ModelBuilder.leapYear(td), "lp", ComponentType.CalendarEffect, td.getLpCoefficient());
    }

    private void initializeUserTradingDays(ModelDescription model, TradingDaysSpec td) {
        this.add(model, (ITsVariable)ModelBuilder.userTradingDays(td, this.context), "usertd", ComponentType.CalendarEffect, td.getTdCoefficients());
    }

    private void initializeDefaultTradingDays(ModelDescription model, TradingDaysSpec td) {
        this.add(model, (ITsVariable)ModelBuilder.defaultTradingDays(td), "td", ComponentType.CalendarEffect, td.getTdCoefficients());
        this.add(model, (ITsVariable)ModelBuilder.leapYear(td), "lp", ComponentType.CalendarEffect, td.getLpCoefficient());
    }

    private void initializeStockTradingDays(ModelDescription model, TradingDaysSpec td) {
        this.add(model, (ITsVariable)ModelBuilder.stockTradingDays(td), "td", ComponentType.CalendarEffect, td.getTdCoefficients());
    }

    private static ITradingDaysVariable stockTradingDays(TradingDaysSpec td) {
        return new StockTradingDays(td.getStockTradingDays());
    }

    private void add(@NonNull ModelDescription model, ITsVariable v, @NonNull String name, @NonNull ComponentType cmp, Parameter[] c) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (cmp == null) {
            throw new NullPointerException("cmp is marked non-null but is null");
        }
        if (v == null) {
            return;
        }
        Variable var = Variable.builder().name(name).core(v).coefficients(c).attribute("regeffect", cmp.name()).build();
        model.addVariable(var);
    }

    private void add(@NonNull ModelDescription model, ITsVariable v, @NonNull String name, @NonNull ComponentType cmp, Parameter c) {
        Parameter[] parameterArray;
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (cmp == null) {
            throw new NullPointerException("cmp is marked non-null but is null");
        }
        if (v == null) {
            return;
        }
        Variable.Builder builder = Variable.builder().name(name).core(v);
        if (c == null) {
            parameterArray = null;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = c;
        }
        Variable var = builder.coefficients(parameterArray).attribute("regeffect", cmp.name()).build();
        model.addVariable(var);
    }

    public static ITradingDaysVariable tradingDays(ModellingSpec spec, ModellingContext context) {
        TradingDaysSpec tdspec = spec.getRegression().getCalendar().getTradingDays();
        if (!tdspec.isUsed()) {
            return null;
        }
        if (tdspec.isStockTradingDays()) {
            return new StockTradingDays(tdspec.getStockTradingDays());
        }
        if (tdspec.getHolidays() != null) {
            return ModelBuilder.holidays(tdspec, context);
        }
        if (tdspec.getUserVariables() != null) {
            return ModelBuilder.userTradingDays(tdspec, context);
        }
        return ModelBuilder.defaultTradingDays(tdspec);
    }

    public static ITradingDaysVariable td(ModellingSpec spec, DayClustering dc, ModellingContext context) {
        TradingDaysSpec tdspec = spec.getRegression().getCalendar().getTradingDays();
        if (!tdspec.isUsed()) {
            return null;
        }
        if (tdspec.isStockTradingDays()) {
            return null;
        }
        if (tdspec.getHolidays() != null) {
            GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
            HolidaysCorrectedTradingDays.HolidaysCorrector corrector = HolidaysCorrectionFactory.corrector((String)tdspec.getHolidays(), (CalendarManager)context.getCalendars(), (DayOfWeek)DayOfWeek.SUNDAY);
            return HolidaysCorrectedTradingDays.builder().corrector(corrector).clustering(gtd.getClustering()).build();
        }
        if (tdspec.getUserVariables() != null) {
            return null;
        }
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        return new GenericTradingDaysVariable(gtd);
    }

    private static ITradingDaysVariable defaultTradingDays(TradingDaysSpec td) {
        if (td.getTradingDaysType() == TradingDaysType.NONE) {
            return null;
        }
        TradingDaysType tdType = td.getTradingDaysType();
        if (td.isAutomatic()) {
            tdType = TradingDaysType.TD7;
        }
        DayClustering dc = DayClustering.of((TradingDaysType)tdType);
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        return new GenericTradingDaysVariable(gtd);
    }

    private static ITradingDaysVariable holidays(TradingDaysSpec td, ModellingContext context) {
        if (td.getTradingDaysType() == TradingDaysType.NONE) {
            return null;
        }
        TradingDaysType tdType = td.getTradingDaysType();
        if (td.isAutomatic()) {
            tdType = TradingDaysType.TD7;
        }
        DayClustering dc = DayClustering.of((TradingDaysType)tdType);
        HolidaysCorrectedTradingDays.HolidaysCorrector corrector = HolidaysCorrectionFactory.corrector((String)td.getHolidays(), (CalendarManager)context.getCalendars(), (DayOfWeek)DayOfWeek.SUNDAY);
        return HolidaysCorrectedTradingDays.builder().clustering(dc).corrector(corrector).contrast(true).build();
    }

    private static ITradingDaysVariable userTradingDays(TradingDaysSpec td, ModellingContext context) {
        String[] userVariables = td.getUserVariables();
        return UserTradingDays.of((String[])userVariables, (ModellingContext)context);
    }

    public static ILengthOfPeriodVariable leapYear(TradingDaysSpec tdspec) {
        if (tdspec.getLengthOfPeriodType() == LengthOfPeriodType.None) {
            return null;
        }
        return new LengthOfPeriod(tdspec.getLengthOfPeriodType());
    }

    public static IEasterVariable easter(EasterSpec.Type type, int w) {
        return switch (type) {
            case EasterSpec.Type.JULIANEASTER -> new JulianEasterVariable(w, true);
            case EasterSpec.Type.EASTER -> EasterVariable.builder().duration(w).meanCorrection(EasterVariable.Correction.Simple).endPosition(-1).build();
            default -> null;
        };
    }

    public static IEasterVariable easter(ModellingSpec spec) {
        EasterSpec espec = spec.getRegression().getCalendar().getEaster();
        if (!espec.isUsed()) {
            return null;
        }
        if (espec.isJulian()) {
            return new JulianEasterVariable(espec.getDuration(), true);
        }
        return EasterVariable.builder().duration(espec.getDuration()).meanCorrection(EasterVariable.Correction.Simple).endPosition(-1).build();
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ami", "demetra");
        map.put("regeffect", ComponentType.CalendarEffect.name());
        calendarAMI = Collections.unmodifiableMap(map);
    }
}

