/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.regarima;

import java.util.Arrays;
import jdplus.sa.base.core.regarima.AutomaticTradingRegressionModule;
import jdplus.sa.base.core.regarima.ModelBuilder;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.TradingDaysRegressionComparator;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;

public class AutomaticTradingDaysWaldTest
implements AutomaticTradingRegressionModule {
    public static final double DEF_TLP = 2.0;
    private final ITradingDaysVariable[] td;
    private final ILengthOfPeriodVariable lp;
    private final double tlp;
    private final double fpvalue;
    private final double pconstraint;
    private final double precision;
    private final boolean adjust;

    public static Builder builder() {
        return new Builder();
    }

    private AutomaticTradingDaysWaldTest(Builder builder) {
        this.td = builder.td;
        this.lp = builder.lp;
        this.tlp = builder.tlp;
        this.fpvalue = builder.fpvalue;
        this.pconstraint = builder.pconstraint;
        this.precision = builder.precision;
        this.adjust = builder.adjust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult test(RegSarimaModelling context) {
        context.getLog().push("automatic trading days selection");
        try {
            ModelDescription current = context.getDescription();
            RegArimaEstimation[] estimations = TradingDaysRegressionComparator.test((ModelDescription)current, (ITradingDaysVariable[])this.td, (ILengthOfPeriodVariable)this.lp, (double)this.precision);
            int best = TradingDaysRegressionComparator.waldTest((RegArimaEstimation[])estimations, (double)this.fpvalue, (double)this.pconstraint);
            ITradingDaysVariable tdsel = best < 2 ? null : this.td[best - 2];
            ILengthOfPeriodVariable lpsel = best < 1 ? null : this.lp;
            AutomaticTradingRegressionModule.Info info = new AutomaticTradingRegressionModule.Info(AutomaticTradingRegressionModule.modelNames(this.td), (LikelihoodStatistics[])Arrays.stream(estimations).map(e -> e == null ? null : e.statistics()).toArray(LikelihoodStatistics[]::new), best);
            context.getLog().info("selected trading days: " + info.getNames()[best], (Object)info);
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.precision);
            ModelDescription model = this.createTestModel(context, tdsel, lpsel);
            RegArimaEstimation regarima = processor.process(model.regarima(), model.mapping());
            int nhp = current.getArimaSpec().freeParametersCount();
            ProcessingResult processingResult = this.update(current, model, tdsel, lpsel, regarima.getConcentratedLikelihood(), nhp);
            return processingResult;
        }
        catch (RuntimeException ex) {
            context.getLog().remark("automatic trading days selection failed");
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            context.getLog().pop();
        }
    }

    private ModelDescription createTestModel(RegSarimaModelling context, ITradingDaysVariable td, ILengthOfPeriodVariable lp) {
        ModelDescription tmp = ModelDescription.copyOf((ModelDescription)context.getDescription());
        tmp.setAirline(true);
        tmp.setMean(true);
        if (td != null) {
            tmp.addVariable(Variable.variable((String)"td", (ITsVariable)td, ModelBuilder.calendarAMI));
        }
        if (lp != null) {
            tmp.addVariable(Variable.variable((String)"lp", (ITsVariable)lp, ModelBuilder.calendarAMI));
        }
        return tmp;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ProcessingResult update(ModelDescription current, ModelDescription test, ITradingDaysVariable aTd, ILengthOfPeriodVariable aLp, ConcentratedLikelihoodWithMissing ll, int nhp) {
        ProcessingResult processingResult;
        int pos;
        double tstat;
        Variable var;
        boolean preadjustment;
        boolean changed;
        block14: {
            block13: {
                changed = false;
                preadjustment = this.adjust && current.isLogTransformation();
                var = current.variable("td");
                if (aTd == null) break block13;
                if (var != null) {
                    if (!var.getCore().equals((Object)aTd)) {
                        current.remove("td");
                        current.addVariable(Variable.variable((String)"td", (ITsVariable)aTd, ModelBuilder.calendarAMI));
                        changed = true;
                    }
                    break block14;
                } else {
                    current.addVariable(Variable.variable((String)"td", (ITsVariable)aTd, ModelBuilder.calendarAMI));
                    changed = true;
                }
                break block14;
            }
            if (var != null) {
                current.remove("td");
                changed = true;
            }
        }
        var = current.variable("lp");
        if (aLp != null && Math.abs(tstat = ll.tstat(pos = test.findPosition((ITsVariable)this.lp), nhp, true)) > this.tlp) {
            if (var != null) {
                if (!preadjustment) return ProcessingResult.Unchanged;
                if (!(tstat > 0.0)) return ProcessingResult.Unchanged;
                current.setPreadjustment(aLp.getType());
                current.remove("lp");
                return ProcessingResult.Changed;
            }
            if (preadjustment && tstat > 0.0) {
                if (!current.isAdjusted()) {
                    current.setPreadjustment(aLp.getType());
                    return ProcessingResult.Changed;
                }
            } else {
                current.addVariable(Variable.variable((String)"lp", (ITsVariable)this.lp, ModelBuilder.calendarAMI));
                return ProcessingResult.Changed;
            }
        }
        if (var != null) {
            current.remove("lp");
            changed = true;
        } else if (current.isAdjusted() && preadjustment) {
            current.setPreadjustment(LengthOfPeriodType.None);
            changed = true;
        }
        if (changed) {
            processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        processingResult = ProcessingResult.Unchanged;
        return processingResult;
    }

    public static class Builder {
        public static final double DEF_PVALUE = 0.01;
        public static final double DEF_CONSTRAINT_PVALUE = 0.1;
        private ITradingDaysVariable[] td;
        private ILengthOfPeriodVariable lp;
        private double tlp = 2.0;
        private double fpvalue = 0.01;
        private double pconstraint = 0.1;
        private double precision = 0.001;
        private boolean adjust = true;

        public Builder tradingDays(ITradingDaysVariable[] td) {
            this.td = (ITradingDaysVariable[])td.clone();
            return this;
        }

        public Builder leapYear(ILengthOfPeriodVariable lp) {
            this.lp = lp;
            return this;
        }

        public Builder lpThreshold(double tlp) {
            this.tlp = tlp;
            return this;
        }

        public Builder pmodel(double p) {
            this.fpvalue = p;
            return this;
        }

        public Builder pconstraint(double p) {
            this.pconstraint = p;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.precision = eps;
            return this;
        }

        public Builder adjust(boolean adjust) {
            this.adjust = adjust;
            return this;
        }

        public AutomaticTradingDaysWaldTest build() {
            return new AutomaticTradingDaysWaldTest(this);
        }
    }
}

