/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysTests;
import jdplus.sa.base.core.diagnostics.SaDiagnosticsUtility;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ResidualTradingDaysDiagnostics
implements Diagnostics {
    private StatisticalTest f_sa;
    private StatisticalTest f_i;
    private double sev;
    private double bad;
    private double unc;
    private boolean td;

    public static ResidualTradingDaysDiagnostics of(ResidualTradingDaysDiagnosticsConfiguration config, Input input) {
        if (input.getTests() == null) {
            return null;
        }
        try {
            ResidualTradingDaysTests tests = input.getTests();
            ResidualTradingDaysDiagnostics test = new ResidualTradingDaysDiagnostics();
            TsData sa = tests.getSa();
            TsData i = tests.getIrr();
            if (sa == null || i == null) {
                return null;
            }
            if (i.getAnnualFrequency() != 12 && config.isMonthlyOnly()) {
                return null;
            }
            test.f_sa = tests.saTest(true);
            boolean isignif = SaDiagnosticsUtility.isSignificant(i.getValues(), sa.getValues());
            if (isignif) {
                test.f_i = tests.irrTest(true);
            }
            test.sev = config.getSevereThreshold();
            test.bad = config.getBadThreshold();
            test.unc = config.getUncertainThreshold();
            test.td = input.isTd();
            return test;
        }
        catch (Exception err) {
            return null;
        }
    }

    public StatisticalTest FTestOnSa() {
        return this.f_sa;
    }

    public StatisticalTest FTestOnI() {
        return this.f_i;
    }

    public String getName() {
        return "Residual trading days tests";
    }

    public List<String> getTests() {
        ArrayList<String> tests = new ArrayList<String>();
        if (this.f_sa != null) {
            tests.add("F-Test on SA (td)");
        }
        if (this.f_i != null) {
            tests.add("F-Test on I (td)");
        }
        return tests;
    }

    public ProcQuality getDiagnostic(String test) {
        return switch (test) {
            case "F-Test on SA (td)" -> this.quality(this.f_sa);
            case "F-Test on I (td)" -> this.quality(this.f_i);
            default -> ProcQuality.Undefined;
        };
    }

    public double getValue(String test) {
        return switch (test) {
            case "F-Test on SA (td)" -> this.pvalue(this.f_sa);
            case "F-Test on I (td)" -> this.pvalue(this.f_i);
            default -> Double.NaN;
        };
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    private ProcQuality quality(StatisticalTest test) {
        if (test == null) {
            return ProcQuality.Undefined;
        }
        double pval = test.getPvalue();
        if (!this.td && pval < this.sev) {
            return ProcQuality.Severe;
        }
        if (pval < this.bad) {
            return ProcQuality.Bad;
        }
        if (pval < this.unc) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    private double pvalue(StatisticalTest test) {
        return test == null ? Double.NaN : test.getPvalue();
    }

    public static final class Input {
        private final ResidualTradingDaysTests tests;
        private final boolean td;

        @Generated
        public Input(ResidualTradingDaysTests tests, boolean td) {
            this.tests = tests;
            this.td = td;
        }

        @Generated
        public ResidualTradingDaysTests getTests() {
            return this.tests;
        }

        @Generated
        public boolean isTd() {
            return this.td;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            if (this.isTd() != other.isTd()) {
                return false;
            }
            ResidualTradingDaysTests this$tests = this.getTests();
            ResidualTradingDaysTests other$tests = other.getTests();
            return !(this$tests == null ? other$tests != null : !this$tests.equals(other$tests));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTd() ? 79 : 97);
            ResidualTradingDaysTests $tests = this.getTests();
            result = result * 59 + ($tests == null ? 43 : $tests.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "ResidualTradingDaysDiagnostics.Input(tests=" + String.valueOf(this.getTests()) + ", td=" + this.isTd() + ")";
        }
    }
}

