/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import jdplus.sa.base.core.diagnostics.CombinedSeasonalityOptions;
import jdplus.sa.base.core.diagnostics.SaDiagnosticsUtility;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFiltersFactory;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class CombinedSeasonalityTests {
    private final boolean mul;
    private final CombinedSeasonalityOptions options;
    private final TsData y;
    private final TsData sa;
    private final TsData irr;
    private final TsData si;
    private final TsData residuals;
    private volatile CombinedSeasonality seasLinearized;
    private volatile CombinedSeasonality seasSI;
    private volatile CombinedSeasonality seasSa;
    private volatile CombinedSeasonality seasI;
    private volatile CombinedSeasonality seasRes;
    private volatile CombinedSeasonality seasSILast;
    private volatile CombinedSeasonality seasSaLast;
    private volatile CombinedSeasonality seasILast;
    private volatile CombinedSeasonality seasResLast;

    private CombinedSeasonalityTests(TsData y, TsData sa, TsData irr, TsData si, TsData residuals, boolean mul, CombinedSeasonalityOptions options) {
        this.mul = mul;
        this.y = y;
        this.sa = sa;
        this.irr = irr;
        this.si = si;
        this.residuals = residuals;
        this.options = options;
    }

    private TsData detrend(TsData s) {
        SymmetricFilter filter = SymmetricFiltersFactory.makeSymmetricFilter((int)s.getAnnualFrequency());
        int ndrop = filter.length() / 2;
        double[] x = new double[s.length() - 2 * ndrop];
        DataBlock out = DataBlock.of((double[])x, (int)0, (int)x.length);
        filter.apply(s.getValues(), (DoubleSeq.Mutable)out);
        if (this.mul) {
            out.apply(s.getValues().drop(ndrop, ndrop), (a, b) -> b / a);
        } else {
            out.apply(s.getValues().drop(ndrop, ndrop), (a, b) -> b - a);
        }
        return TsData.of((TsPeriod)s.getStart().plus((long)ndrop), (DoubleSeq)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedSeasonality linearizedTest() {
        CombinedSeasonality cs = this.seasLinearized;
        if (cs == null) {
            CombinedSeasonalityTests combinedSeasonalityTests = this;
            synchronized (combinedSeasonalityTests) {
                cs = this.seasLinearized;
                if (cs == null) {
                    TsData osi = this.detrend(this.y);
                    this.seasLinearized = cs = SaDiagnosticsUtility.combinedSeasonalityTest(osi, 0, this.mul ? 1.0 : 0.0, false);
                }
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedSeasonality siTest(boolean last) {
        if (last) {
            CombinedSeasonality cs = this.seasSILast;
            if (cs == null) {
                CombinedSeasonalityTests combinedSeasonalityTests = this;
                synchronized (combinedSeasonalityTests) {
                    cs = this.seasSILast;
                    if (cs == null) {
                        this.seasSILast = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.si, this.options.getLastYears(), this.mul ? 1.0 : 0.0, false);
                    }
                }
            }
            return cs;
        }
        CombinedSeasonality cs = this.seasSI;
        if (cs == null) {
            CombinedSeasonalityTests combinedSeasonalityTests = this;
            synchronized (combinedSeasonalityTests) {
                cs = this.seasSI;
                if (cs == null) {
                    this.seasSI = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.si, 0, this.mul ? 1.0 : 0.0, false);
                }
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedSeasonality saTest(boolean last) {
        if (last) {
            CombinedSeasonality cs = this.seasSaLast;
            if (cs == null) {
                CombinedSeasonalityTests combinedSeasonalityTests = this;
                synchronized (combinedSeasonalityTests) {
                    cs = this.seasSaLast;
                    if (cs == null) {
                        this.seasSaLast = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.sa, this.options.getLastYears(), 0.0, true);
                    }
                }
            }
            return cs;
        }
        CombinedSeasonality cs = this.seasSa;
        if (cs == null) {
            CombinedSeasonalityTests combinedSeasonalityTests = this;
            synchronized (combinedSeasonalityTests) {
                cs = this.seasSa;
                if (cs == null) {
                    this.seasSa = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.sa, 0, 0.0, true);
                }
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedSeasonality residualsTest(boolean last) {
        if (this.residuals == null) {
            return null;
        }
        if (last) {
            CombinedSeasonality cs = this.seasResLast;
            if (cs == null) {
                CombinedSeasonalityTests combinedSeasonalityTests = this;
                synchronized (combinedSeasonalityTests) {
                    cs = this.seasResLast;
                    if (cs == null) {
                        this.seasResLast = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.residuals, this.options.getLastYears(), 0.0, false);
                    }
                }
            }
            return cs;
        }
        CombinedSeasonality cs = this.seasRes;
        if (cs == null) {
            CombinedSeasonalityTests combinedSeasonalityTests = this;
            synchronized (combinedSeasonalityTests) {
                cs = this.seasRes;
                if (cs == null) {
                    this.seasRes = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.residuals, 0, 0.0, false);
                }
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedSeasonality irrTest(boolean last) {
        if (last) {
            CombinedSeasonality cs = this.seasILast;
            if (cs == null) {
                CombinedSeasonalityTests combinedSeasonalityTests = this;
                synchronized (combinedSeasonalityTests) {
                    cs = this.seasILast;
                    if (cs == null) {
                        this.seasILast = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.irr, this.options.getLastYears(), this.mul ? 1.0 : 0.0, false);
                    }
                }
            }
            return cs;
        }
        CombinedSeasonality cs = this.seasI;
        if (cs == null) {
            CombinedSeasonalityTests combinedSeasonalityTests = this;
            synchronized (combinedSeasonalityTests) {
                cs = this.seasI;
                if (cs == null) {
                    this.seasI = cs = SaDiagnosticsUtility.combinedSeasonalityTest(this.irr, 0, this.mul ? 1.0 : 0.0, false);
                }
            }
        }
        return cs;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean isMul() {
        return this.mul;
    }

    @Generated
    public CombinedSeasonalityOptions getOptions() {
        return this.options;
    }

    @Generated
    public TsData getY() {
        return this.y;
    }

    @Generated
    public TsData getSa() {
        return this.sa;
    }

    @Generated
    public TsData getIrr() {
        return this.irr;
    }

    @Generated
    public TsData getSi() {
        return this.si;
    }

    @Generated
    public TsData getResiduals() {
        return this.residuals;
    }

    @Generated
    private CombinedSeasonality getSeasLinearized() {
        return this.seasLinearized;
    }

    @Generated
    private CombinedSeasonality getSeasSI() {
        return this.seasSI;
    }

    @Generated
    private CombinedSeasonality getSeasSa() {
        return this.seasSa;
    }

    @Generated
    private CombinedSeasonality getSeasI() {
        return this.seasI;
    }

    @Generated
    private CombinedSeasonality getSeasRes() {
        return this.seasRes;
    }

    @Generated
    private CombinedSeasonality getSeasSILast() {
        return this.seasSILast;
    }

    @Generated
    private CombinedSeasonality getSeasSaLast() {
        return this.seasSaLast;
    }

    @Generated
    private CombinedSeasonality getSeasILast() {
        return this.seasILast;
    }

    @Generated
    private CombinedSeasonality getSeasResLast() {
        return this.seasResLast;
    }

    @Generated
    public static class Builder {
        @Generated
        private TsData y;
        @Generated
        private TsData sa;
        @Generated
        private TsData irr;
        @Generated
        private TsData si;
        @Generated
        private TsData residuals;
        @Generated
        private boolean mul;
        @Generated
        private CombinedSeasonalityOptions options;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder y(TsData y) {
            this.y = y;
            return this;
        }

        @Generated
        public @NonNull Builder sa(TsData sa) {
            this.sa = sa;
            return this;
        }

        @Generated
        public @NonNull Builder irr(TsData irr) {
            this.irr = irr;
            return this;
        }

        @Generated
        public @NonNull Builder si(TsData si) {
            this.si = si;
            return this;
        }

        @Generated
        public @NonNull Builder residuals(TsData residuals) {
            this.residuals = residuals;
            return this;
        }

        @Generated
        public @NonNull Builder mul(boolean mul) {
            this.mul = mul;
            return this;
        }

        @Generated
        public @NonNull Builder options(CombinedSeasonalityOptions options) {
            this.options = options;
            return this;
        }

        @Generated
        public @NonNull CombinedSeasonalityTests build() {
            return new CombinedSeasonalityTests(this.y, this.sa, this.irr, this.si, this.residuals, this.mul, this.options);
        }

        @Generated
        public @NonNull String toString() {
            return "CombinedSeasonalityTests.Builder(y=" + String.valueOf(this.y) + ", sa=" + String.valueOf(this.sa) + ", irr=" + String.valueOf(this.irr) + ", si=" + String.valueOf(this.si) + ", residuals=" + String.valueOf(this.residuals) + ", mul=" + this.mul + ", options=" + String.valueOf(this.options) + ")";
        }
    }
}

