/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core;

import jdplus.sa.base.api.StationaryVarianceDecomposition;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.ssf.arima.SsfUcarima;
import jdplus.toolkit.base.core.ssf.composite.CompositeSsf;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;

public class StationaryVarianceComputer {
    public static final ILongTermTrendComputer LINEARTREND = new LinearTrendComputer();
    public static final ILongTermTrendComputer HP = new HPTrendComputer();
    public final ILongTermTrendComputer trendComputer;

    public StationaryVarianceComputer() {
        this.trendComputer = LINEARTREND;
    }

    public StationaryVarianceComputer(ILongTermTrendComputer trendComputer) {
        this.trendComputer = trendComputer;
    }

    public StationaryVarianceDecomposition build(TsData O, TsData T, TsData S, TsData I, TsData Cal, TsData others, boolean mul) {
        TsData Pc;
        TsData Calc;
        TsData Ic;
        TsData Sc;
        TsData stCc;
        TsData stOc;
        if (O == null) {
            return null;
        }
        if (mul) {
            stOc = O.log();
            stCc = T != null ? T.log() : null;
            Sc = S != null ? S.log() : null;
            Ic = I != null ? I.log() : null;
            Calc = Cal != null ? Cal.log() : null;
            Pc = others != null ? others.log() : null;
        } else {
            stOc = O;
            stCc = T;
            Sc = S;
            Ic = I;
            Calc = Cal;
            Pc = others;
        }
        Calc = this.cleanup(Calc);
        Pc = this.cleanup(Pc);
        if (stCc != null) {
            TsData lt = this.trendComputer.calcLongTermTrend(stCc);
            stCc = TsData.subtract((TsData)stCc, (TsData)lt);
            stOc = TsData.subtract((TsData)stOc, (TsData)lt);
        }
        DescriptiveStatistics stats = DescriptiveStatistics.of((DoubleSeq)stOc.getValues());
        double varO = stats.getVar();
        if (stCc != null) {
            stats = DescriptiveStatistics.of((DoubleSeq)stCc.getValues());
            varC = stats.getVar();
        } else {
            varC = 0.0;
        }
        if (Sc != null) {
            stats = DescriptiveStatistics.of((DoubleSeq)Sc.getValues());
            varS = stats.getVar();
        } else {
            varS = 0.0;
        }
        if (Ic != null) {
            stats = DescriptiveStatistics.of((DoubleSeq)Ic.getValues());
            varI = stats.getVar();
        } else {
            varI = 0.0;
        }
        if (Calc != null) {
            stats = DescriptiveStatistics.of((DoubleSeq)Calc.getValues());
            varCal = stats.getVar();
        } else {
            varCal = 0.0;
        }
        if (Pc != null) {
            stats = DescriptiveStatistics.of((DoubleSeq)Pc.getValues());
            varP = stats.getVar();
        } else {
            varP = 0.0;
        }
        return StationaryVarianceDecomposition.builder().trendType(this.type()).C(varC /= varO).S(varS /= varO).I(varI /= varO).P(varP /= varO).Calendar(varCal /= varO).build();
    }

    private StationaryVarianceDecomposition.TrendType type() {
        if (this.trendComputer instanceof LinearTrendComputer) {
            return StationaryVarianceDecomposition.TrendType.Linear;
        }
        if (this.trendComputer instanceof HPTrendComputer) {
            return StationaryVarianceDecomposition.TrendType.HodrickPrescott;
        }
        return StationaryVarianceDecomposition.TrendType.Other;
    }

    private TsData cleanup(TsData s) {
        if (s == null || s.getValues().allMatch(x -> Math.abs(x) < 1.0E-12)) {
            return null;
        }
        return s;
    }

    public static interface ILongTermTrendComputer {
        public TsData calcLongTermTrend(TsData var1);
    }

    private static class LinearTrendComputer
    implements ILongTermTrendComputer {
        private LinearTrendComputer() {
        }

        @Override
        public TsData calcLongTermTrend(TsData s) {
            if (s == null) {
                return null;
            }
            DataBlock x = DataBlock.make((int)s.length());
            x.set(1.0);
            x.cumul();
            LinearModel model = LinearModel.builder().y(s.getValues()).meanCorrection(true).addX((DoubleSeq)x).build();
            LeastSquaresResults ls = Ols.compute((LinearModel)model);
            DoubleSeq b = ls.getCoefficients();
            x.mul(b.get(1));
            x.add(b.get(0));
            return TsData.of((TsPeriod)s.getStart(), (DoubleSeq)x);
        }

        public String toString() {
            return "Linear trend computed by Ols";
        }
    }

    public static class HPTrendComputer
    implements ILongTermTrendComputer {
        private final double cyclelen;

        public HPTrendComputer() {
            this.cyclelen = 8.0;
        }

        public HPTrendComputer(double len) {
            this.cyclelen = len;
        }

        public static double defaultLambda(double ylen, int freq) {
            double w = Math.PI * 2 / ((double)freq * ylen);
            double x = 1.0 - Math.cos(w);
            return 0.75 / (x * x);
        }

        @Override
        public TsData calcLongTermTrend(TsData s) {
            Polynomial D = UnitRoots.D((int)1);
            Polynomial D2 = D.times(D);
            double lambda = HPTrendComputer.defaultLambda(this.cyclelen, s.getAnnualFrequency());
            ArimaModel i2 = new ArimaModel(BackFilter.ONE, new BackFilter(D2), BackFilter.ONE, 1.0);
            ArimaModel wn = new ArimaModel(BackFilter.ONE, BackFilter.ONE, BackFilter.ONE, lambda);
            UcarimaModel ucm = UcarimaModel.builder().add(i2).add(wn).build();
            CompositeSsf ssf = SsfUcarima.of((UcarimaModel)ucm);
            DataBlockStorage ss = DkToolkit.fastSmooth((ISsf)ssf, (ISsfData)new SsfData(s.getValues()));
            return TsData.ofInternal((TsPeriod)s.getStart(), (double[])ss.item(0).toArray());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Trend computed by Hodrick-Prescott filter (cycle length = ").append(this.cyclelen).append(" years)");
            return builder.toString();
        }
    }
}

