/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataTable;

public final class SeriesDecomposition
implements GenericExplorable {
    private final DecompositionMode mode;
    private final Map<ComponentType, TsData> bcmps;
    private final Map<ComponentType, TsData> cmps;
    private final Map<ComponentType, TsData> fcmps;
    private final Map<ComponentType, TsData> ebcmps;
    private final Map<ComponentType, TsData> ecmps;
    private final Map<ComponentType, TsData> efcmps;

    public static Builder builder(DecompositionMode mode) {
        return new Builder(mode);
    }

    private SeriesDecomposition(Builder builder) {
        this.mode = builder.mode;
        this.cmps = Collections.unmodifiableMap(builder.cmps);
        this.fcmps = Collections.unmodifiableMap(builder.fcmps);
        this.ecmps = Collections.unmodifiableMap(builder.ecmps);
        this.efcmps = Collections.unmodifiableMap(builder.efcmps);
        this.bcmps = Collections.unmodifiableMap(builder.bcmps);
        this.ebcmps = Collections.unmodifiableMap(builder.ebcmps);
    }

    public DecompositionMode getMode() {
        return this.mode;
    }

    public TsData getSeries(ComponentType cmp, ComponentInformation info) {
        switch (info) {
            case Stdev: {
                return this.ecmps.get((Object)cmp);
            }
            case Forecast: {
                return this.fcmps.get((Object)cmp);
            }
            case StdevForecast: {
                return this.efcmps.get((Object)cmp);
            }
            case Backcast: {
                return this.bcmps.get((Object)cmp);
            }
            case StdevBackcast: {
                return this.ebcmps.get((Object)cmp);
            }
        }
        return this.cmps.get((Object)cmp);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.bcmps.isEmpty()) {
            builder.append("backcasts").append("\r\n");
            this.write(this.bcmps, builder);
        }
        if (!this.cmps.isEmpty()) {
            builder.append("components").append("\r\n");
            this.write(this.cmps, builder);
        }
        if (!this.fcmps.isEmpty()) {
            builder.append("forecasts").append("\r\n");
            this.write(this.fcmps, builder);
        }
        if (!this.ebcmps.isEmpty()) {
            builder.append("backcasts errors").append("\r\n");
            this.write(this.ebcmps, builder);
        }
        if (!this.ecmps.isEmpty()) {
            builder.append("components errors").append("\r\n");
            this.write(this.ecmps, builder);
        }
        if (!this.efcmps.isEmpty()) {
            builder.append("forecasts errors").append("\r\n");
            this.write(this.efcmps, builder);
        }
        return builder.toString();
    }

    private void write(Map<ComponentType, TsData> cmps, StringBuilder builder) {
        ArrayList<TsData> all = new ArrayList<TsData>();
        TsData s = cmps.get((Object)ComponentType.Series);
        if (s != null) {
            all.add(s);
        }
        if ((s = cmps.get((Object)ComponentType.SeasonallyAdjusted)) != null) {
            all.add(s);
        }
        if ((s = cmps.get((Object)ComponentType.Trend)) != null) {
            all.add(s);
        }
        if ((s = cmps.get((Object)ComponentType.Seasonal)) != null) {
            all.add(s);
        }
        if ((s = cmps.get((Object)ComponentType.Irregular)) != null) {
            all.add(s);
        }
        builder.append(TsDataTable.of(all)).append("\r\n");
    }

    public static class Builder {
        private final DecompositionMode mode;
        private final EnumMap<ComponentType, TsData> cmps = new EnumMap(ComponentType.class);
        private final EnumMap<ComponentType, TsData> bcmps = new EnumMap(ComponentType.class);
        private final EnumMap<ComponentType, TsData> fcmps = new EnumMap(ComponentType.class);
        private final EnumMap<ComponentType, TsData> ecmps = new EnumMap(ComponentType.class);
        private final EnumMap<ComponentType, TsData> ebcmps = new EnumMap(ComponentType.class);
        private final EnumMap<ComponentType, TsData> efcmps = new EnumMap(ComponentType.class);

        private Builder(DecompositionMode mode) {
            this.mode = mode;
        }

        public Builder add(TsData data, ComponentType cmp) {
            return this.add(data, cmp, ComponentInformation.Value);
        }

        public Builder add(TsData data, ComponentType cmp, ComponentInformation info) {
            switch (info) {
                case Stdev: {
                    this.ecmps.put(cmp, data);
                    break;
                }
                case Forecast: {
                    this.fcmps.put(cmp, data);
                    break;
                }
                case StdevForecast: {
                    this.efcmps.put(cmp, data);
                    break;
                }
                case Backcast: {
                    this.bcmps.put(cmp, data);
                    break;
                }
                case StdevBackcast: {
                    this.ebcmps.put(cmp, data);
                    break;
                }
                default: {
                    this.cmps.put(cmp, data);
                }
            }
            return this;
        }

        public SeriesDecomposition build() {
            return new SeriesDecomposition(this);
        }
    }
}

