/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import jdplus.sa.base.api.ComponentType;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.SwitchOutlier;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import lombok.Generated;

public final class SaVariable {
    public static final String REGEFFECT = "regeffect";

    public static ComponentType defaultComponentTypeOf(IOutlier v) {
        if (v instanceof AdditiveOutlier || v instanceof TransitoryChange || v instanceof SwitchOutlier) {
            return ComponentType.Irregular;
        }
        if (v instanceof LevelShift) {
            return ComponentType.Trend;
        }
        if (v instanceof PeriodicOutlier) {
            return ComponentType.Seasonal;
        }
        return ComponentType.Undefined;
    }

    public static ComponentType defaultComponentTypeOf(InterventionVariable var) {
        if (var.getDeltaSeasonal() > 0.0 && var.getDelta() > 0.0) {
            return ComponentType.Undefined;
        }
        List sequences = var.getSequences();
        int maxseq = 0;
        for (Range seq : sequences) {
            int len = (int)((LocalDateTime)seq.start()).until((Temporal)((Object)seq.end()), ChronoUnit.DAYS) / 365;
            if (len <= maxseq) continue;
            maxseq = len;
        }
        if (maxseq > 0) {
            return var.getDeltaSeasonal() == 0.0 ? ComponentType.Trend : ComponentType.Undefined;
        }
        if (var.getDeltaSeasonal() > 0.0) {
            return ComponentType.Seasonal;
        }
        if (var.getDelta() > 0.8) {
            return ComponentType.Trend;
        }
        return ComponentType.Irregular;
    }

    public static boolean isRegressionEffect(Variable var, ComponentType type) {
        String effect = var.attribute(REGEFFECT);
        return effect == null ? type == ComponentType.Undefined : effect.equals(type.name());
    }

    public static ComponentType regressionEffect(Variable var) {
        String effect = var.attribute(REGEFFECT);
        return effect == null ? ComponentType.Undefined : ComponentType.valueOf(effect);
    }

    public static Variable setComponentType(Variable var, ComponentType type) {
        return var.setAttribute(REGEFFECT, type.name());
    }

    @Generated
    private SaVariable() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

