/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import jdplus.sa.base.api.EstimationPolicy;
import jdplus.sa.base.api.SaItem;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SaItems {
    @NonNull
    private final String name;
    @NonNull
    private final Map<String, String> meta;
    @NonNull
    private final List<SaItem> items;
    private static final SaItems EMPTY = new SaItems("", Collections.emptyMap(), Collections.emptyList());

    public static Builder builder() {
        return new Builder().name("");
    }

    public static SaItems empty() {
        return EMPTY;
    }

    public List<SaItem> refresh(EstimationPolicy policy, TsInformationType info) {
        ArrayList<SaItem> list = new ArrayList<SaItem>();
        for (SaItem cur : this.items) {
            list.add(cur.refresh(policy, info));
        }
        return list;
    }

    public SaItems withMetadata(Map<String, String> meta) {
        return new SaItems(this.name, Collections.unmodifiableMap(meta), this.items);
    }

    public SaItems withItem(int pos, SaItem nitem) {
        ArrayList<SaItem> nitems = new ArrayList<SaItem>(this.items);
        nitems.set(pos, nitem);
        return new SaItems(this.name, this.meta, Collections.unmodifiableList(nitems));
    }

    public SaItems replaceItem(SaItem oitem, SaItem nitem) {
        ArrayList<SaItem> nitems = new ArrayList<SaItem>();
        for (SaItem cur : this.items) {
            if (cur == oitem) {
                nitems.add(nitem);
                continue;
            }
            nitems.add(cur);
        }
        return new SaItems(this.name, this.meta, Collections.unmodifiableList(nitems));
    }

    public SaItems replaceItems(Predicate<SaItem> test, UnaryOperator<SaItem> op) {
        ArrayList<SaItem> nitems = new ArrayList<SaItem>();
        for (SaItem cur : this.items) {
            if (test.test(cur)) {
                nitems.add((SaItem)op.apply(cur));
                continue;
            }
            nitems.add(cur);
        }
        return new SaItems(this.name, this.meta, Collections.unmodifiableList(nitems));
    }

    public SaItems refresh(EstimationPolicy policy, TsInformationType info, Predicate<SaItem> test) {
        Builder builder = this.toBuilder().clearItems();
        for (SaItem cur : this.items) {
            if (test.test(cur)) {
                builder.item(cur.refresh(policy, info));
                continue;
            }
            builder.item(cur);
        }
        return builder.build();
    }

    public SaItems removeItems(SaItem ... nitems) {
        ArrayList<SaItem> ritems = new ArrayList<SaItem>();
        HashSet<SaItem> sitems = new HashSet<SaItem>();
        for (SaItem item : nitems) {
            sitems.add(item);
        }
        for (SaItem item : this.items) {
            if (sitems.contains(item)) continue;
            ritems.add(item);
        }
        return new SaItems(this.name, this.meta, Collections.unmodifiableList(ritems));
    }

    public SaItems addItems(SaItem ... nitems) {
        ArrayList<SaItem> ritems = new ArrayList<SaItem>(this.items);
        for (SaItem item : nitems) {
            ritems.add(item);
        }
        return new SaItems(this.name, this.meta, Collections.unmodifiableList(ritems));
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int size() {
        return this.items.size();
    }

    public SaItem item(int i) {
        return this.items.get(i);
    }

    @Generated
    SaItems(@NonNull String name, @NonNull Map<String, String> meta, @NonNull List<SaItem> items) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.name = name;
        this.meta = meta;
        this.items = items;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().name(this.name);
        if (this.meta != null) {
            builder.meta(this.meta);
        }
        if (this.items != null) {
            builder.items(this.items);
        }
        return builder;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @NonNull
    @Generated
    public List<SaItem> getItems() {
        return this.items;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaItems)) {
            return false;
        }
        SaItems other = (SaItems)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$meta = this.getMeta();
        Map<String, String> other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        List<SaItem> this$items = this.getItems();
        List<SaItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        List<SaItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "SaItems(name=" + this.getName() + ", meta=" + String.valueOf(this.getMeta()) + ", items=" + String.valueOf(this.getItems()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private ArrayList<String> meta$key;
        @Generated
        private ArrayList<String> meta$value;
        @Generated
        private ArrayList<SaItem> items;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(String metaKey, String metaValue) {
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            this.meta$key.add(metaKey);
            this.meta$value.add(metaValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> meta) {
            if (meta == null) {
                throw new NullPointerException("meta cannot be null");
            }
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : meta.entrySet()) {
                this.meta$key.add($lombokEntry.getKey());
                this.meta$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearMeta() {
            if (this.meta$key != null) {
                this.meta$key.clear();
                this.meta$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder item(SaItem item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder items(@org.jspecify.annotations.NonNull Collection<? extends SaItem> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull SaItems build() {
            Map<String, String> meta;
            switch (this.meta$key == null ? 0 : this.meta$key.size()) {
                case 0: {
                    meta = Collections.emptyMap();
                    break;
                }
                case 1: {
                    meta = Collections.singletonMap(this.meta$key.get(0), this.meta$value.get(0));
                    break;
                }
                default: {
                    meta = new LinkedHashMap(this.meta$key.size() < 0x40000000 ? 1 + this.meta$key.size() + (this.meta$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.meta$key.size(); ++$i) {
                        meta.put(this.meta$key.get($i), this.meta$value.get($i));
                    }
                    meta = Collections.unmodifiableMap(meta);
                }
            }
            return new SaItems(this.name, meta, switch (this.items == null ? 0 : this.items.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.items.get(0));
                default -> Collections.unmodifiableList(new ArrayList<SaItem>(this.items));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "SaItems.Builder(name=" + this.name + ", meta$key=" + String.valueOf(this.meta$key) + ", meta$value=" + String.valueOf(this.meta$value) + ", items=" + String.valueOf(this.items) + ")";
        }
    }
}

