/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.ILinearProcess;
import jdplus.toolkit.base.core.arima.LinearProcess;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.ForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimator;

public class WienerKolmogorovEstimators {
    private final UcarimaModel ucm;
    private WienerKolmogorovEstimator[][] finals;

    public WienerKolmogorovEstimators(UcarimaModel ucm) {
        this.ucm = ucm;
    }

    private void calcestimator(int cmp, boolean signal) throws ArimaException, MatrixException {
        BackFilter denom;
        int k;
        if (this.ucm == null) {
            return;
        }
        int n = k = signal ? 1 : 0;
        if (this.finals == null) {
            this.finals = new WienerKolmogorovEstimator[this.ucm.getComponentsCount()][2];
        } else if (this.finals[cmp][k] != null) {
            return;
        }
        ArimaModel a = this.ucm.getComponent(cmp);
        ArimaModel s = signal ? a : this.ucm.getComplement(cmp);
        BackFilter nar = this.ucm.getModel().getStationaryAr();
        BackFilter dar = s.getStationaryAr();
        BackFilter nur = this.ucm.getModel().getNonStationaryAr();
        BackFilter dur = s.getNonStationaryAr();
        if (this.isSpecial(this.ucm)) {
            BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool();
            if (smp.simplify(nar, dar)) {
                nar = (BackFilter)smp.getLeft();
                dar = (BackFilter)smp.getRight();
            }
            nur = nur.divide(dur);
            nar = nar.times(nur);
            denom = this.ucm.getModel().getMa().times(dar);
        } else {
            nur = nur.divide(dur);
            nar = nar.divide(dar);
            nar = nar.times(nur);
            denom = this.ucm.getModel().getMa();
        }
        BackFilter num = s.getMa().times(nar);
        SymmetricFilter c = SymmetricFilter.convolutionOf(num);
        double svar = s.getInnovationVariance();
        double mvar = this.ucm.getModel().getInnovationVariance();
        c = c.times(svar / mvar);
        BackFilter gf = c.decompose(denom);
        RationalBackFilter rb = new RationalBackFilter(gf, denom, 0);
        RationalFilter f = new RationalFilter(rb, rb.mirror(), c, SymmetricFilter.convolutionOf(denom));
        RationalFilter mf = RationalFilter.of(s.getMa().times(svar / mvar), s.getAr(), num.mirror(), denom.mirror());
        LinearProcess m = new LinearProcess(mf, mvar);
        this.finals[cmp][k] = new WienerKolmogorovEstimator(f, m);
    }

    private boolean isSpecial(UcarimaModel ucm) {
        int n = ucm.getModel().getArOrder();
        for (ArimaModel m : ucm.getComponents()) {
            n -= m.getArOrder();
        }
        return n != 0;
    }

    public ArimaModel finalErrorModel(int cmp) throws ArimaException {
        if (this.ucm == null) {
            return null;
        }
        ArimaModel s = this.ucm.getComponent(cmp);
        if (s.isNull()) {
            return null;
        }
        ArimaModel n = this.ucm.getComplement(cmp);
        IArimaModel model = this.ucm.getModel();
        BackFilter ar = model.getMa();
        SymmetricFilter ss = s.symmetricMa();
        SymmetricFilter sn = n.symmetricMa();
        SymmetricFilter num = ss.times(sn);
        return new ArimaModel(ar, BackFilter.ONE, num);
    }

    public WienerKolmogorovEstimator finalEstimator(int cmp, boolean signal) throws ArimaException, MatrixException {
        if (this.ucm == null) {
            return null;
        }
        ArimaModel a = this.ucm.getComponent(cmp);
        if (a.isNull()) {
            return null;
        }
        this.calcestimator(cmp, signal);
        return this.finals[cmp][signal ? 1 : 0];
    }

    public StationaryTransformation<ILinearProcess> finalStationaryEstimator(int cmp, boolean signal) throws ArimaException {
        ArimaModel a;
        if (this.ucm == null) {
            return null;
        }
        IArimaModel model = this.ucm.getModel();
        ArimaModel arimaModel = a = signal ? this.ucm.getComponent(cmp) : this.ucm.getComplement(cmp);
        if (a.isNull()) {
            return null;
        }
        BackFilter nar = this.ucm.getModel().getStationaryAr();
        BackFilter dar = a.getStationaryAr();
        BackFilter nur = this.ucm.getModel().getNonStationaryAr();
        BackFilter dur = a.getNonStationaryAr();
        BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool();
        if (smp.simplify(nar, dar)) {
            nar = (BackFilter)smp.getLeft();
            dar = (BackFilter)smp.getRight();
        }
        nur = nur.divide(dur);
        nar = nar.times(nur);
        BackFilter denom = model.getMa().times(dar);
        BackFilter num = a.getMa().times(nar);
        double avar = a.getInnovationVariance();
        double mvar = model.getInnovationVariance();
        BackFilter star = a.getStationaryAr();
        BackFilter ur = a.getNonStationaryAr();
        RationalFilter mf = RationalFilter.of(a.getMa().times(avar / mvar), star, num.mirror(), denom.mirror());
        return new StationaryTransformation<ILinearProcess>(new LinearProcess(mf, mvar), ur);
    }

    public UcarimaModel getUcarimaModel() {
        return this.ucm;
    }

    public LinearProcess revisionModel(int cmp, int n) throws ArimaException, MatrixException {
        if (n < 0) {
            return null;
        }
        LinearProcess ln = this.finalEstimator(cmp, true).getEstimatorModel();
        RationalFilter rf = ln.getFilter();
        RationalForeFilter rff = rf.getRationalForeFilter().drop(n + 1);
        ForeFilter num = rff.getNumerator();
        ForeFilter denom = rff.getDenominator();
        RationalFilter crf = RationalFilter.of(new RationalForeFilter(num, denom, 0));
        return new LinearProcess(crf, ln.getInnovationVariance());
    }

    public AutoCovarianceFunction totalErrorAcf(int cmp, int n) {
        LinearProcess rev = this.revisionModel(cmp, n);
        ArimaModel fm = this.finalErrorModel(cmp);
        RationalForeFilter rf = rev.getFilter().getRationalForeFilter();
        BackFilter rnum = rf.getNumerator().mirror();
        double n0 = rnum.get(0);
        ArimaModel rm = new ArimaModel(rf.getDenominator().mirror(), BackFilter.ONE, rnum.normalize(), rev.getInnovationVariance() * n0 * n0);
        return fm.plus(rm).getAutoCovarianceFunction();
    }

    public AutoCovarianceFunction revisionAcf(int cmp, int n) {
        LinearProcess rev = this.revisionModel(cmp, n);
        return rev.getAutoCovarianceFunction();
    }

    public double[] revisionVariance(int cmp, boolean signal, int start, int n) throws ArimaException, MatrixException {
        double w;
        int i;
        if (this.ucm.getComponent(cmp).isNull()) {
            return null;
        }
        double[] rvar = new double[n];
        double var0 = this.revisionModel(cmp, 0).getAutoCovarianceFunction().get(0);
        LinearProcess lm = this.finalEstimator(cmp, signal).getEstimatorModel();
        RationalFilter rf = lm.getFilter();
        double mvar = lm.getInnovationVariance();
        if (start <= 0 && -start < n) {
            rvar[-start] = var0;
        }
        double var = var0;
        IntToDoubleFunction weights = rf.weights();
        for (i = -1; i >= start; --i) {
            w = weights.applyAsDouble(i + 1);
            var += w * w * mvar;
            if (i - start >= n) continue;
            rvar[i - start] = var;
        }
        var = var0;
        for (i = 1; i < start; ++i) {
            w = weights.applyAsDouble(i);
            if (!((var -= w * w * mvar) <= 0.0)) continue;
            return rvar;
        }
        for (i = Math.max(start, 1); i < n + start && !((var -= (w = weights.applyAsDouble(i)) * w * mvar) <= 0.0); ++i) {
            rvar[i - start] = var;
        }
        return rvar;
    }

    public double[] relativeRevisionVariance(int cmp, boolean signal, int start, int n) throws ArimaException, MatrixException {
        if (this.ucm.getComponent(cmp).isNull()) {
            return null;
        }
        double[] rvar = new double[n];
        LinearProcess lm = this.finalEstimator(cmp, signal).getEstimatorModel();
        RationalFilter rf = lm.getFilter();
        double mvar = lm.getInnovationVariance();
        IntToDoubleFunction weights = rf.weights();
        double var = 0.0;
        for (int i = 1; i < n; ++i) {
            double w = weights.applyAsDouble(i + start);
            rvar[i] = var += w * w * mvar;
        }
        return rvar;
    }

    public double[] totalErrorVariance(int cmp, boolean signal, int start, int n) throws ArimaException, MatrixException {
        if (this.ucm.getComponent(cmp).isNull()) {
            return null;
        }
        double[] tvar = this.revisionVariance(cmp, signal, start, n);
        double fvar = this.finalErrorModel(cmp).getAutoCovarianceFunction().get(0);
        int i = 0;
        while (i < tvar.length) {
            int n2 = i++;
            tvar[n2] = tvar[n2] + fvar;
        }
        return tvar;
    }

    public double variationPrecision(int cmp, int start, int del, boolean all) {
        if (this.ucm.getComponent(cmp).isNull()) {
            return Double.NaN;
        }
        LinearProcess me = this.finalEstimator(cmp, true).getEstimatorModel();
        RationalFilter fe = me.getFilter();
        IntToDoubleFunction weights = fe.weights();
        double mv = me.getInnovationVariance();
        AutoCovarianceFunction acf = all ? this.totalErrorAcf(cmp, start) : this.revisionAcf(cmp, start);
        double v = 2.0 * (acf.get(0) - acf.get(del));
        for (int i = 0; i < del; ++i) {
            double x = weights.applyAsDouble(i + start + 1);
            v -= x * x * mv;
        }
        return v;
    }

    public double variationRevisionVariance(int cmp, int start, int del, int nrevs) {
        if (this.ucm.getComponent(cmp).isNull()) {
            return Double.NaN;
        }
        LinearProcess me = this.finalEstimator(cmp, true).getEstimatorModel();
        RationalFilter fe = me.getFilter();
        IntToDoubleFunction weights = fe.weights();
        double mv = me.getInnovationVariance();
        double v = 0.0;
        for (int i = 1; i <= nrevs; ++i) {
            double x = weights.applyAsDouble(i + start);
            double y = weights.applyAsDouble(i + start + del);
            v += x * x + y * y - 2.0 * x * y;
        }
        return v * mv;
    }
}

