/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import java.util.ArrayList;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.Spectrum;
import jdplus.toolkit.base.core.ucarima.UcarimaException;

public class UcarimaModel {
    private static final double EPS = 1.0E-6;
    private final IArimaModel model;
    private final ArimaModel[] components;
    private final ArimaModel[] complements;
    private volatile ArimaModel sum;

    public static Builder builder() {
        return new Builder();
    }

    UcarimaModel(IArimaModel model, ArimaModel[] cmps) {
        this.model = model;
        this.components = cmps;
        this.complements = new ArimaModel[cmps.length];
    }

    public UcarimaModel compact(int istart, int count) {
        int i;
        Builder builder = new Builder();
        builder.model(this.model);
        for (int i2 = 0; i2 < istart; ++i2) {
            builder.add(this.components[i2]);
        }
        ArimaModel sum = this.components[istart];
        for (i = 1; i < count; ++i) {
            sum = sum.plus(this.components[istart + i], false);
        }
        builder.add(sum);
        for (i = istart + count; i < this.components.length; ++i) {
            builder.add(this.components[i]);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArimaModel getComplement(int cmp) {
        if (this.components.length <= 1) {
            return ArimaModel.NULL;
        }
        ArimaModel m = this.complements[cmp];
        if (m == null) {
            UcarimaModel ucarimaModel = this;
            synchronized (ucarimaModel) {
                m = ArimaModel.NULL;
                for (int i = 0; i < this.components.length; ++i) {
                    ArimaModel cur;
                    if (cmp == i || (cur = this.components[i]).isNull()) continue;
                    m = m.plus(cur, false);
                }
                this.complements[cmp] = m;
            }
        }
        return m;
    }

    public ArimaModel getComponent(int idx) {
        return this.components[idx];
    }

    public int getComponentsCount() {
        return this.components.length;
    }

    public IArimaModel getModel() {
        return this.model;
    }

    private ArimaModel of(ArimaModel m) {
        return new ArimaModel(m.getStationaryAr(), m.getNonStationaryAr(), m.getMa(), m.getInnovationVariance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArimaModel sum() {
        ArimaModel s = this.sum;
        if (s == null) {
            UcarimaModel ucarimaModel = this;
            synchronized (ucarimaModel) {
                s = this.sum;
                if (s == null) {
                    s = ArimaModel.NULL;
                    for (int i = 0; i < this.components.length; ++i) {
                        if (this.components[i].isNull()) continue;
                        s = s.plus(this.of(this.components[i]), false);
                    }
                    this.sum = s;
                }
            }
        }
        return s;
    }

    public ArimaModel[] getComponents() {
        int n = 0;
        for (ArimaModel cmp : this.components) {
            if (cmp == null) continue;
            ++n;
        }
        ArimaModel[] cmps = new ArimaModel[n];
        n = 0;
        for (ArimaModel cmp : this.components) {
            if (cmp == null) continue;
            cmps[n++] = cmp;
        }
        return cmps;
    }

    public boolean isValid() {
        try {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i].getInnovationVariance() < 0.0)) continue;
                return false;
            }
            return true;
        }
        catch (ArimaException e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UcarimaModel setVarianceMax(int ncmp, boolean adjustModel) {
        ArimaModel[] ncmps;
        double var = 0.0;
        if (this.components.length == 0) {
            return this;
        }
        int n = this.components.length;
        if (ncmp < 0) {
            ncmps = new ArimaModel[n + 1];
            System.arraycopy(this.components, 0, ncmps, 0, n);
            ncmps[n] = ArimaModel.NULL;
            ncmp = n;
        } else {
            ncmps = (ArimaModel[])this.components.clone();
        }
        Spectrum.Minimizer min = new Spectrum.Minimizer();
        for (int i = 0; i < ncmps.length; ++i) {
            ArimaModel m;
            if (i == ncmp || (m = ncmps[i]) == null) continue;
            min.minimize(m.getSpectrum());
            if (min.getMinimum() == 0.0) continue;
            var += min.getMinimum();
            ncmps[i] = m.minus(min.getMinimum());
        }
        IArimaModel nmodel = this.model;
        if (var < 0.0) {
            if (!adjustModel) return null;
            nmodel = ArimaModel.add(-var, ArimaModel.of(this.model));
            return new UcarimaModel(nmodel, ncmps);
        } else {
            ncmps[ncmp] = ncmps[ncmp].plus(var);
        }
        return new UcarimaModel(nmodel, ncmps);
    }

    public UcarimaModel simplify() {
        Builder builder = new Builder();
        builder.model = this.model;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].isNull()) continue;
            builder.add(this.components[i]);
        }
        return builder.build();
    }

    public UcarimaModel normalize() {
        double var = this.model.getInnovationVariance();
        if (Math.abs(var - 1.0) < 1.0E-6) {
            return this;
        }
        ArimaModel nmodel = ArimaModel.of(this.model).normalize();
        ArimaModel[] ncmps = (ArimaModel[])this.components.clone();
        for (int i = 0; i < this.components.length; ++i) {
            ArimaModel cur = this.components[i];
            if (cur.isNull()) continue;
            ncmps[i] = ncmps[i].scaleVariance(1.0 / var);
        }
        return new UcarimaModel(nmodel, ncmps);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Model: ").append(this.getModel()).append(System.lineSeparator());
        int j = 0;
        for (int i = 0; i < this.components.length; ++i) {
            ArimaModel cmp = this.components[i];
            if (cmp.isNull()) continue;
            builder.append("component").append(++j).append(": ").append(cmp).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static class Builder {
        private IArimaModel model;
        private ArrayList<ArimaModel> components = new ArrayList();
        private boolean verify = false;

        private Builder() {
        }

        public UcarimaModel build() {
            ArimaModel sum;
            if (this.verify && this.model != null && !ArimaModel.same(this.model, sum = this.sum(), 1.0E-6)) {
                throw new UcarimaException();
            }
            return new UcarimaModel(this.model == null ? this.sum() : this.model, this.components.toArray(new ArimaModel[this.components.size()]));
        }

        public Builder verify(boolean verify) {
            this.verify = verify;
            return this;
        }

        public Builder add(ArimaModel component) {
            this.components.add(component);
            return this;
        }

        public Builder model(IArimaModel model) {
            this.model = model;
            return this;
        }

        public Builder add(ArimaModel ... components) {
            if (components == null) {
                throw new NullPointerException("components is marked non-null but is null");
            }
            for (int i = 0; i < components.length; ++i) {
                this.components.add(components[i]);
            }
            return this;
        }

        public final ArimaModel sum() {
            if (this.components.isEmpty()) {
                return ArimaModel.NULL;
            }
            ArimaModel sum = this.components.get(0);
            for (int i = 1; i < this.components.size(); ++i) {
                sum = sum.plus(this.components.get(i), false);
            }
            return sum;
        }
    }
}

