/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticException;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticInfo;

public class SlidingSpans<I> {
    private Node<I>[] m_estimation;
    private final Function<TsDomain, I> m_processing;
    private final TsDomain m_domainT;
    private final I m_reference;
    private int m_spanLength = 8;
    private int m_spanCount = 4;
    private final int m_spanDistance = 1;
    private int m_spanMin = 2;

    public SlidingSpans(TsDomain domain, Function<TsDomain, I> processing) {
        this.m_processing = processing;
        this.m_domainT = domain;
        this.m_reference = processing.apply(this.m_domainT);
    }

    private void addDel(int p, HashMap<TsPeriod, MaxMin> buffer, TsData data) {
        TsPeriod start = data.getStart();
        for (int i = p; i < data.length(); ++i) {
            TsPeriod cur = start.plus((long)i);
            MaxMin Mm = buffer.get(cur);
            if (Mm == null) {
                Mm = new MaxMin();
                buffer.put(cur, Mm);
            }
            Mm.add(data.getValue(i) - data.getValue(i - p));
        }
    }

    private void addPct(int p, HashMap<TsPeriod, MaxMin> buffer, TsData data) {
        TsPeriod start = data.getStart();
        for (int i = p; i < data.length(); ++i) {
            TsPeriod cur = start.plus((long)i);
            MaxMin Mm = buffer.get(cur);
            if (Mm == null) {
                Mm = new MaxMin();
                buffer.put(cur, Mm);
            }
            Mm.add(data.getValue(i) / data.getValue(i - p));
        }
    }

    private void addValue(HashMap<TsPeriod, MaxMin> buffer, TsData data) {
        TsPeriod start = data.getStart();
        for (int i = 0; i < data.length(); ++i) {
            TsPeriod cur = start.plus((long)i);
            MaxMin Mm = buffer.get(cur);
            if (Mm == null) {
                Mm = new MaxMin();
                buffer.put(cur, Mm);
            }
            Mm.add(data.getValue(i));
        }
    }

    public int getMaxSpanCount() {
        return this.m_spanCount;
    }

    public int getMinSpanCount() {
        return this.m_spanMin;
    }

    public Function<TsDomain, I> getProcessing() {
        return this.m_processing;
    }

    public I getReferenceInfo() {
        return this.m_reference;
    }

    public TsDomain getReferenceDomain() {
        return this.m_domainT;
    }

    public int getSpanCount() {
        if (this.m_estimation == null && !this.process()) {
            return 0;
        }
        return this.m_estimation.length;
    }

    public int getSpanLength() {
        return this.m_spanLength;
    }

    public I info(int idx) {
        if (this.m_estimation == null && !this.process()) {
            return null;
        }
        return this.m_estimation.length <= idx ? null : (I)this.m_estimation[idx].estimation;
    }

    public TsDomain getDomain(int idx) {
        if (this.m_estimation == null && !this.process()) {
            return null;
        }
        return this.m_estimation.length <= idx ? null : this.m_estimation[idx].domain;
    }

    public boolean isValid() {
        if (this.m_estimation == null && !this.process()) {
            return false;
        }
        return this.m_estimation.length >= this.m_spanMin;
    }

    public boolean process() {
        if (this.m_estimation != null) {
            return true;
        }
        ArrayList rslts = new ArrayList();
        int freq = this.m_domainT.getAnnualFrequency();
        int length = this.m_spanLength * freq;
        TsPeriod start = this.m_domainT.getLastPeriod().plus((long)(1 - length));
        if (start.annualPosition() != 0) {
            length += start.annualPosition();
            start = start.plus((long)(-start.annualPosition()));
        }
        int idx = 0;
        while (idx < this.m_spanCount && !start.isBefore(this.m_domainT.getStartPeriod())) {
            try {
                ++idx;
                TsDomain cur = TsDomain.of((TsPeriod)start, (int)length);
                I info = this.m_processing.apply(cur);
                if (info == null) break;
                Node node = new Node();
                node.estimation = info;
                node.domain = cur;
                rslts.add(node);
                start = start.plus((long)(-1 * freq));
            }
            catch (Exception err) {
                // empty catch block
                break;
            }
        }
        if (rslts.size() < this.m_spanMin) {
            return false;
        }
        this.m_estimation = (Node[])rslts.toArray(Node[]::new);
        Arrays2.reverse((Object[])this.m_estimation);
        return true;
    }

    public TsData referenceSeries(Function<I, TsData> fn) {
        if (this.m_reference == null) {
            return null;
        }
        return fn.apply(this.m_reference);
    }

    public void setMaxSpanCount(int value) {
        if (value != this.m_spanCount) {
            this.m_estimation = null;
        }
        this.m_spanCount = value;
    }

    public void setMinSpanCount(int value) {
        if (value < 2) {
            throw new DiagnosticException("Invalid argument in sliding spans analysis ");
        }
        this.m_spanMin = value;
    }

    public void setSpanLength(int value) {
        if (value != this.m_spanLength) {
            this.m_estimation = null;
        }
        this.m_spanLength = value;
    }

    public TsData statistics(DiagnosticInfo info, Function<I, TsData> function) {
        if (this.m_estimation == null && !this.process()) {
            return null;
        }
        if (this.getSpanCount() < this.getMinSpanCount()) {
            return null;
        }
        HashMap<TsPeriod, MaxMin> buffer = new HashMap<TsPeriod, MaxMin>();
        block6: for (int i = 0; i < this.m_estimation.length; ++i) {
            TsData data = function.apply(this.m_estimation[i].estimation);
            if (data == null) continue;
            switch (info) {
                case PeriodToPeriodGrowthDifference: {
                    this.addPct(1, buffer, data);
                    continue block6;
                }
                case AnnualGrowthDifference: {
                    this.addPct(data.getAnnualFrequency(), buffer, data);
                    continue block6;
                }
                case PeriodToPeriodDifference: {
                    this.addDel(1, buffer, data);
                    continue block6;
                }
                case AnnualDifference: {
                    this.addDel(data.getAnnualFrequency(), buffer, data);
                    continue block6;
                }
                default: {
                    this.addValue(buffer, data);
                }
            }
        }
        double[] x = new double[this.m_domainT.length()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Double.NaN;
        }
        TsPeriod start = this.m_domainT.getStartPeriod();
        for (Map.Entry kv : buffer.entrySet()) {
            if (((MaxMin)kv.getValue()).count < this.m_spanMin) continue;
            int idx = start.until((TsPeriod)kv.getKey());
            x[idx] = ((MaxMin)kv.getValue()).value(info);
        }
        return TsData.ofInternal((TsPeriod)start, (double[])x).cleanExtremities();
    }

    class MaxMin {
        double max;
        double min;
        int count;

        MaxMin() {
        }

        void add(double val) {
            if (this.count == 0) {
                this.max = val;
                this.min = val;
            } else {
                if (val > this.max) {
                    this.max = val;
                }
                if (val < this.min) {
                    this.min = val;
                }
            }
            ++this.count;
        }

        double value(DiagnosticInfo info) {
            if (info == DiagnosticInfo.RelativeDifference) {
                return (this.max - this.min) / this.min;
            }
            return this.max - this.min;
        }
    }

    private static class Node<I> {
        TsDomain domain;
        I estimation;

        private Node() {
        }
    }
}

