/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets.analysis;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticInfo;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticTarget;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticTsFunction;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.TsDataFunction;

public class RevisionHistory<T> {
    private final Function<TsDomain, T> m_processing;
    private final HashMap<TsDomain, T> m_cache = new HashMap();
    private final TsDomain m_domainT;

    public RevisionHistory(TsDomain domain, Function<TsDomain, T> processing) {
        this.m_processing = processing;
        this.m_domainT = domain;
        this.m_cache.put(this.m_domainT, processing.apply(this.m_domainT));
    }

    public Function<TsDomain, T> getProcessing() {
        return this.m_processing;
    }

    public TsDomain getReferenceDomain() {
        return this.m_domainT;
    }

    public T getReferenceInfo() {
        return this.tsInfo(this.m_domainT);
    }

    public double[] laggedSeriesRevision(TsPeriod period, int lag, int count, DiagnosticInfo mode, DiagnosticTarget target, Function<T, TsData> extractor) {
        TsPeriod start = this.m_domainT.getStartPeriod();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)(start.until(period) + 1));
        ArrayList<T> ilag = new ArrayList<T>(count);
        TsDomain ldomain = domain;
        for (int i = 0; i < count; ++i) {
            ldomain = ldomain.extend(0, lag);
            ilag.add(this.tsInfo(ldomain));
        }
        double[] rslt = new double[count];
        if (target == DiagnosticTarget.Final) {
            TsData Tdata;
            T iT = this.tsInfo(this.m_domainT);
            TsData tsData = Tdata = iT != null ? extractor.apply(iT) : null;
            if (Tdata == null) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                TsData tdata;
                rslt[i] = Double.NaN;
                Object cur = ilag.get(i);
                if (cur == null || (tdata = extractor.apply(cur)) == null) continue;
                int idx = tdata.length() - 1;
                rslt[i] = mode.asFunction().apply(Tdata, tdata, idx);
            }
        } else {
            TsData cdata;
            T it = this.tsInfo(domain);
            TsData tsData = cdata = it != null ? extractor.apply(it) : null;
            if (cdata == null) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                TsData tdata;
                rslt[i] = Double.NaN;
                Object cur = ilag.get(i);
                if (cur == null || (tdata = extractor.apply(cur)) == null) continue;
                int idx = tdata.length() - 1;
                rslt[i] = mode.asFunction().apply(cdata, tdata, idx);
            }
        }
        return rslt;
    }

    public TsData referenceSeries(Function<T, TsData> extractor) {
        T it = this.tsInfo(this.m_domainT);
        return it == null ? null : extractor.apply(it);
    }

    public TsData revision(TsPeriod start, ToDoubleFunction<T> extractor) {
        TsPeriod p0 = this.m_domainT.getStartPeriod();
        double[] x = new double[start.until(this.m_domainT.getEndPeriod())];
        int len = p0.until(start) + 1;
        int i = 0;
        while (i < x.length) {
            TsDomain rdom = TsDomain.of((TsPeriod)p0, (int)len);
            T output = this.tsInfo(rdom);
            if (output != null) {
                x[i] = extractor.applyAsDouble(output);
            }
            ++i;
            ++len;
        }
        return TsData.ofInternal((TsPeriod)start, (double[])x);
    }

    public List<TsData> select(LocalDate beg, LocalDate end, Function<T, TsData> extractor) {
        int n;
        ArrayList<TsData> s = new ArrayList<TsData>();
        TsPeriod start = this.m_domainT.getStartPeriod();
        TsPeriod pbeg = start.withDate(beg.atStartOfDay());
        TsPeriod pend = start.withDate(end.atStartOfDay());
        if (pend.isAfter(this.m_domainT.getLastPeriod())) {
            pend = this.m_domainT.getLastPeriod();
        }
        if ((n = pbeg.until(pend)) >= 0) {
            int len = start.until(pbeg) + 1;
            for (int i = 0; i <= n; ++i) {
                try {
                    TsData q;
                    TsDomain dom = TsDomain.of((TsPeriod)start, (int)len++);
                    T output = this.tsInfo(dom);
                    if (output == null || (q = extractor.apply(output)) == null) continue;
                    s.add(q);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return s;
    }

    public TsData series(TsPeriod period, Function<T, TsData> extractor) {
        TsPeriod start = this.m_domainT.getStartPeriod();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)(start.until(period) + 1));
        T it = this.tsInfo(domain);
        if (it == null) {
            return null;
        }
        return extractor.apply(it);
    }

    public double seriesRevision(TsPeriod period, DiagnosticInfo mode, Function<T, TsData> extractor) {
        return this.seriesRevision(period, mode.asFunction(), extractor);
    }

    public double seriesRevision(TsPeriod period, DiagnosticTsFunction fn, Function<T, TsData> extractor) {
        TsPeriod start = this.m_domainT.getStartPeriod();
        TsDomain domain = TsDomain.of((TsPeriod)start, (int)(start.until(period) + 1));
        T it = this.tsInfo(domain);
        if (it == null) {
            return Double.NaN;
        }
        T iT = this.tsInfo(this.m_domainT);
        TsData tdata = extractor.apply(it);
        TsData Tdata = extractor.apply(iT);
        if (tdata == null || Tdata == null) {
            return Double.NaN;
        }
        int idx = domain.getLength() - 1;
        return fn.apply(Tdata, tdata, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T tsInfo(TsDomain domain) {
        HashMap<TsDomain, T> hashMap = this.m_cache;
        synchronized (hashMap) {
            T info = this.m_cache.get(domain);
            if (info == null) {
                info = this.m_processing.apply(domain);
                this.m_cache.put(domain, info);
            }
            return info;
        }
    }

    public TsData tsRevision(TsPeriod period, TsPeriod start, Function<T, TsData> extractor) {
        TsPeriod p0 = this.m_domainT.getStartPeriod();
        int n = start.until(this.m_domainT.getEndPeriod());
        if (n <= 0) {
            return null;
        }
        double[] x = new double[n];
        int len = p0.until(start) + 1;
        int i = 0;
        while (i < x.length) {
            TsDomain rdom = TsDomain.of((TsPeriod)p0, (int)len);
            T output = this.tsInfo(rdom);
            if (output != null) {
                TsData t = extractor.apply(output);
                x[i] = t != null ? t.getDoubleValue(period) : Double.NaN;
            }
            ++i;
            ++len;
        }
        return TsData.ofInternal((TsPeriod)start, (double[])x);
    }

    public TsData tsRevision(TsPeriod period, TsPeriod start, TsDataFunction fn, Function<T, TsData> extractor) {
        TsPeriod p0 = this.m_domainT.getStartPeriod();
        int pos = p0.until(period);
        double[] x = new double[start.until(this.m_domainT.getEndPeriod())];
        int len = p0.until(start) + 1;
        int i = 0;
        while (i < x.length) {
            TsDomain rdom = TsDomain.of((TsPeriod)p0, (int)len);
            T output = this.tsInfo(rdom);
            if (output != null) {
                TsData t = extractor.apply(output);
                x[i] = t != null ? fn.apply(t, pos) : Double.NaN;
            }
            ++i;
            ++len;
        }
        return TsData.ofInternal((TsPeriod)start, (double[])x);
    }
}

