/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.LocalDate;
import java.util.Iterator;
import jdplus.toolkit.base.api.timeseries.calendars.SingleDate;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayInfo;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class SingleDateInfo
implements HolidayInfo {
    private final SingleDate fdate;

    SingleDateInfo(SingleDate fdate) {
        this.fdate = fdate;
    }

    @Override
    public LocalDate getDay() {
        return this.fdate.getDate();
    }

    @Generated
    public SingleDate getFdate() {
        return this.fdate;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleDateInfo)) {
            return false;
        }
        SingleDateInfo other = (SingleDateInfo)o;
        SingleDate this$fdate = this.getFdate();
        SingleDate other$fdate = other.getFdate();
        return !(this$fdate == null ? other$fdate != null : !this$fdate.equals(other$fdate));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SingleDate $fdate = this.getFdate();
        result = result * 59 + ($fdate == null ? 43 : $fdate.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SingleDateInfo(fdate=" + String.valueOf(this.getFdate()) + ")";
    }

    static class SingleDateIterable
    implements Iterable<HolidayInfo> {
        private final SingleDate fdate;
        private final boolean valid;

        SingleDateIterable(SingleDate fdate, LocalDate fstart, LocalDate fend) {
            this.fdate = fdate;
            this.valid = !fdate.getDate().isBefore(fstart) && fdate.getDate().isBefore(fend);
        }

        @Override
        public Iterator<HolidayInfo> iterator() {
            return new Iterator<HolidayInfo>(){
                boolean done = false;

                @Override
                public boolean hasNext() {
                    return valid && !this.done;
                }

                @Override
                public HolidayInfo next() {
                    this.done = true;
                    return new SingleDateInfo(fdate);
                }
            };
        }
    }
}

