/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.F;
import lombok.Generated;

public final class TestsUtility {
    public static double pvalue(ContinuousDistribution distribution, double value, TestType type) {
        try {
            switch (type) {
                case TwoSided: {
                    if (!distribution.isSymmetrical()) {
                        throw new DStatException("misspecified test");
                    }
                    double mean = distribution.getExpectation();
                    return 2.0 * distribution.getProbability(value, value < mean ? ProbabilityType.Lower : ProbabilityType.Upper);
                }
                case Lower: {
                    return distribution.getProbability(value, ProbabilityType.Lower);
                }
                case Upper: {
                    return distribution.getProbability(value, ProbabilityType.Upper);
                }
            }
            return 0.0;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static StatisticalTest testOf(double value, ContinuousDistribution dist, TestType type) {
        return new StatisticalTest(value, TestsUtility.pvalue(dist, value, type), dist.getDescription());
    }

    public static StatisticalTest ofAnova(OneWayAnova anova) {
        F f = new F(anova.getDfm(), anova.getDfr());
        return TestsUtility.testOf(anova.ftest(), f, TestType.Upper);
    }

    @Generated
    private TestsUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

