/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.T;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class Mean {
    private final double mean;
    private final double emean;
    private final double var;
    private final int n;

    private Mean(double mean, double emean, double var, int n) {
        this.mean = mean;
        this.emean = emean;
        this.var = var;
        this.n = n;
    }

    public static Mean zeroMean(DoubleSeq data) {
        int nmissing = data.count(x -> !Double.isFinite(x));
        int m = data.length() - nmissing;
        if (nmissing > 0) {
            double av = data.sumWithMissing() / (double)m;
            double v = data.ssqWithMissing() / (double)m;
            return new Mean(av, 0.0, v, m);
        }
        double av = data.sum() / (double)m;
        double v = data.ssq() / (double)m;
        return new Mean(av, 0.0, v, m);
    }

    public static Mean mean(DoubleSeq data, double mu) {
        int nmissing = data.count(x -> !Double.isFinite(x));
        int m = data.length() - nmissing;
        if (nmissing > 0) {
            double av = data.sumWithMissing() / (double)m;
            double v = data.ssqcWithMissing(mu) / (double)m;
            return new Mean(av, mu, v, m);
        }
        double av = data.sum() / (double)m;
        double v = data.ssqc(mu) / (double)m;
        return new Mean(av, mu, v, m);
    }

    public StatisticalTest build() {
        double val = (this.mean - this.emean) / Math.sqrt(this.var / (double)this.n);
        return TestsUtility.testOf(val, new T(this.n), TestType.TwoSided);
    }
}

