/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.core.math.splines.CubicSpline;
import jdplus.toolkit.base.core.stats.tests.DickeyFuller;
import lombok.Generated;

public final class DickeyFullerTable {
    private static final double[][] T_NC = new double[][]{{-3.59, -2.66, -2.26, -1.95, -1.61, 0.92, 1.33, 1.7, 2.16, 3.12}, {-3.42, -2.62, -2.25, -1.95, -1.61, 0.91, 1.31, 1.66, 2.08, 2.97}, {-3.35, -2.6, -2.24, -1.95, -1.61, 0.9, 1.29, 1.64, 2.03, 2.88}, {-3.31, -2.58, -2.23, -1.95, -1.61, 0.89, 1.29, 1.63, 2.01, 2.85}, {-3.29, -2.57, -2.23, -1.95, -1.61, 0.89, 1.28, 1.62, 2.01, 2.83}, {-3.28, -2.57, -2.23, -1.94, -1.61, 0.89, 1.28, 1.62, 2.01, 2.82}};
    private static final double[][] T_C = new double[][]{{-4.73, -3.75, -3.33, -3.0, -2.62, -0.37, 0.0, 0.34, 0.72, 1.57}, {-4.37, -3.58, -3.22, -2.93, -2.6, -0.4, -0.03, 0.29, 0.66, 1.46}, {-4.23, -3.51, -3.17, -2.89, -2.58, -0.42, -0.05, 0.26, 0.63, 1.41}, {-4.15, -3.46, -3.14, -2.88, -2.57, -0.42, -0.06, 0.24, 0.62, 1.39}, {-4.12, -3.44, -3.13, -2.87, -2.57, -0.43, -0.07, 0.24, 0.61, 1.38}, {-4.1, -3.43, -3.12, -2.86, -2.57, -0.44, -0.08, 0.24, 0.61, 1.38}};
    private static final double[][] T_CT = new double[][]{{-5.44, -4.38, -3.95, -3.6, -3.24, -1.14, -0.8, -0.5, -0.15, 0.61}, {-4.97, -4.15, -3.8, -3.5, -3.18, -1.19, -0.87, -0.58, -0.24, 0.49}, {-4.77, -4.04, -3.73, -3.45, -3.15, -1.22, -0.9, -0.62, -0.28, 0.43}, {-4.67, -3.99, -3.69, -3.43, -3.13, -1.23, -0.92, -0.64, -0.31, 0.4}, {-4.63, -3.98, -3.68, -3.42, -3.13, -1.24, -0.93, -0.65, -0.31, 0.4}, {-4.61, -3.96, -3.67, -3.41, -3.13, -1.24, -0.94, -0.66, -0.32, 0.39}};
    private static final double[][] Z_NC = new double[][]{{-17.1, -11.9, -9.3, -7.3, -5.3, 1.01, 1.4, 1.79, 2.28, 3.5}, {-19.4, -12.9, -9.9, -7.7, -5.5, 0.97, 1.35, 1.7, 2.16, 3.29}, {-20.6, -13.3, -10.2, -7.9, -5.6, 0.95, 1.31, 1.65, 2.09, 3.2}, {-21.6, -13.6, -10.3, -8.0, -5.7, 0.93, 1.29, 1.62, 2.04, 3.13}, {-21.9, -13.7, -10.4, -8.0, -5.7, 0.93, 1.29, 1.61, 2.04, 3.12}, {-22.1, -13.7, -10.4, -8.0, -5.7, 0.93, 1.29, 1.61, 2.03, 3.1}};
    private static final double[][] Z_C = new double[][]{{-22.0, -17.2, -14.6, -12.5, -10.2, -0.76, 0.01, 0.65, 1.4, 3.0}, {-25.7, -18.9, -15.7, -13.3, -10.7, -0.81, -0.07, 0.53, 1.22, 2.7}, {-27.6, -19.8, -16.3, -13.7, -11.0, -0.83, -0.1, 0.47, 1.14, 2.53}, {-29.0, -20.3, -16.6, -14.0, -11.2, -0.84, -0.12, 0.43, 1.09, 2.47}, {-29.4, -20.5, -16.8, -14.0, -11.2, -0.84, -0.13, 0.42, 1.06, 2.44}, {-29.8, -20.6, -16.9, -14.1, -11.2, -0.85, -0.14, 0.41, 1.05, 2.42}};
    private static final double[][] Z_CT = new double[][]{{-26.9, -22.5, -19.9, -17.9, -15.6, -3.66, -2.51, -1.53, -0.43, 1.76}, {-32.5, -25.7, -22.4, -19.8, -16.8, -3.71, -2.6, -1.66, -0.65, 1.29}, {-35.9, -27.4, -23.6, -20.7, -17.5, -3.74, -2.62, -1.73, -0.75, 1.13}, {-38.2, -28.4, -24.4, -21.3, -18.0, -3.75, -2.64, -1.78, -0.82, 1.03}, {-39.0, -28.9, -24.8, -21.5, -18.1, -3.76, -2.65, -1.78, -0.84, 0.99}, {-39.6, -29.2, -25.0, -21.7, -18.2, -3.76, -2.66, -1.79, -0.85, 0.98}};
    private static final double[] NOBS = new double[]{25.0, 50.0, 100.0, 250.0, 500.0, 1000.0};
    private static final double[] PROB = new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.9, 0.95, 0.975, 0.99, 0.999};
    private static final double[] PROBL = (double[])PROB.clone();

    private static double[][] adfTable(DickeyFuller.DickeyFullerType type, boolean z) {
        if (z) {
            switch (type) {
                case NC: {
                    return Z_NC;
                }
                case C: {
                    return Z_C;
                }
            }
            return Z_CT;
        }
        switch (type) {
            case NC: {
                return T_NC;
            }
            case C: {
                return T_C;
            }
        }
        return T_CT;
    }

    public static double probability3(int n, double q, DickeyFuller.DickeyFullerType type) {
        double[][] adfTable = DickeyFullerTable.adfTable(type, false);
        double[] pd = new double[NOBS.length];
        for (int i = 0; i < pd.length; ++i) {
            double pi = CubicSpline.monotonic(adfTable[i], PROB).applyAsDouble(q);
            if (pi < 0.0) {
                pi = 0.0;
            }
            if (pi > 1.0) {
                pi = 1.0;
            }
            pd[i] = pi;
        }
        double p = CubicSpline.monotonic(NOBS, pd).applyAsDouble(n);
        if (p < 0.0) {
            return 0.0;
        }
        if (p > 1.0) {
            return 1.0;
        }
        return p;
    }

    public static double probability2(int n, double q, DickeyFuller.DickeyFullerType type) {
        double[][] adfTable = DickeyFullerTable.adfTable(type, false);
        double[] pd = new double[NOBS.length];
        for (int i = 0; i < pd.length; ++i) {
            double pi = CubicSpline.of(adfTable[i], PROB).applyAsDouble(q);
            if (pi < 0.0) {
                pi = 0.0;
            }
            if (pi > 1.0) {
                pi = 1.0;
            }
            pd[i] = pi;
        }
        double p = CubicSpline.of(NOBS, pd).applyAsDouble(n);
        if (p < 0.0) {
            return 0.0;
        }
        if (p > 1.0) {
            return 1.0;
        }
        return p;
    }

    public static double probability(int n, double q, DickeyFuller.DickeyFullerType type, boolean ztest) {
        double[][] adfTable = DickeyFullerTable.adfTable(type, ztest);
        double[] pd = new double[NOBS.length];
        for (int i = 0; i < pd.length; ++i) {
            pd[i] = CubicSpline.of(adfTable[i], PROBL).applyAsDouble(q);
        }
        double p = CubicSpline.of(NOBS, pd).applyAsDouble(n);
        return Math.exp(p) / (1.0 + Math.exp(p));
    }

    @Generated
    private DickeyFullerTable() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (int i = 0; i < PROBL.length; ++i) {
            DickeyFullerTable.PROBL[i] = -Math.log(1.0 / PROBL[i] - 1.0);
        }
    }
}

