/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import java.util.ArrayList;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.NonNull;
import nbbrd.design.Internal;

public final class LinearModel {
    private final double[] y;
    private final boolean mean;
    private final FastMatrix x;

    public static Builder builder() {
        return new Builder();
    }

    @Internal
    public LinearModel(double[] y, boolean mean, FastMatrix x) {
        this.y = y;
        this.mean = mean;
        this.x = x;
    }

    public DataBlock calcResiduals(DoubleSeq b) {
        if (this.getVariablesCount() != b.length()) {
            throw new RuntimeException("Incompatible dimensions");
        }
        DataBlock res = DataBlock.make(this.y.length);
        res.copyFrom(this.y, 0);
        DoubleSeqCursor cell = b.cursor();
        if (this.mean) {
            res.add(-cell.getAndNext());
        }
        DataBlockIterator columns = this.x.columnsIterator();
        while (columns.hasNext()) {
            res.addAY(-cell.getAndNext(), columns.next());
        }
        return res;
    }

    public int getObservationsCount() {
        return this.y.length;
    }

    public int getVariablesCount() {
        int n = this.x.getColumnsCount();
        if (this.mean) {
            ++n;
        }
        return n;
    }

    public int getXCount() {
        return this.x.getColumnsCount();
    }

    public DoubleSeq getY() {
        return DoubleSeq.of((double[])this.y);
    }

    public boolean isMeanCorrection() {
        return this.mean;
    }

    public FastMatrix getX() {
        return this.x;
    }

    public FastMatrix variables() {
        if (!this.mean) {
            return this.x.deepClone();
        }
        int m = this.x.getRowsCount();
        int n = this.x.getColumnsCount();
        FastMatrix vars = FastMatrix.make(m, n + 1);
        vars.column(0).set(1.0);
        vars.extract(0, m, 1, n).copy(this.x);
        return vars;
    }

    public DoubleSeq X(int idx) {
        return this.x.column(idx);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("y~").append(this.mean ? (char)'1' : '0');
        if (!this.x.isEmpty()) {
            builder.append("+x(").append(this.x.getColumnsCount()).append(')');
        }
        return builder.toString();
    }

    public static class Builder {
        private double[] y;
        private boolean mean;
        private final ArrayList<DoubleSeq> x = new ArrayList();

        private Builder() {
        }

        public Builder meanCorrection(boolean mean) {
            this.mean = mean;
            return this;
        }

        public Builder y(@NonNull DoubleSeq y) {
            if (y == null) {
                throw new NullPointerException("y is marked non-null but is null");
            }
            this.y = y.toArray();
            return this;
        }

        public Builder addX(@NonNull DoubleSeq var) {
            if (var == null) {
                throw new NullPointerException("var is marked non-null but is null");
            }
            this.x.add(var);
            return this;
        }

        public Builder addX(@NonNull Matrix X) {
            if (X == null) {
                throw new NullPointerException("X is marked non-null but is null");
            }
            for (int i = 0; i < X.getColumnsCount(); ++i) {
                this.x.add(X.column(i));
            }
            return this;
        }

        public Builder addX(DoubleSeq ... vars) {
            if (vars == null) {
                throw new NullPointerException("vars is marked non-null but is null");
            }
            for (DoubleSeq var : vars) {
                this.x.add(var);
            }
            return this;
        }

        public LinearModel build() {
            if (this.y == null) {
                throw new RuntimeException("Missing y");
            }
            FastMatrix X = FastMatrix.make(this.y.length, this.x.size());
            if (!X.isEmpty()) {
                DataBlockIterator cols = X.columnsIterator();
                for (DoubleSeq xcur : this.x) {
                    if (xcur.length() != this.y.length) {
                        throw new RuntimeException("Incompatible dimensions");
                    }
                    cols.next().copy(xcur);
                }
            }
            return new LinearModel(this.y, this.mean, X);
        }
    }
}

