/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.analysis.AutoRegressiveSpectrum;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;

public final class InverseAutoCorrelations {
    public static IntToDoubleFunction sampleInverseAutoCorrelationsFunction(DoubleSeq data, int nar) {
        AutoRegressiveSpectrum ar = new AutoRegressiveSpectrum(AutoRegressiveSpectrum.Method.Durbin);
        ar.process(data, Math.min(nar, data.length() / 2));
        DoubleSeq all = ar.getCoefficients();
        double[] par = new double[all.length() + 1];
        all.copyTo(par, 1);
        par[0] = 1.0;
        for (int i2 = 1; i2 < par.length; ++i2) {
            par[i2] = -par[i2];
        }
        SymmetricFilter sfilter = SymmetricFilter.convolutionOf(Polynomial.of(par), 1.0);
        Polynomial p = sfilter.coefficientsAsPolynomial();
        return i -> {
            if (i < 0) {
                i = -i;
            }
            if (i > p.degree()) {
                return 0.0;
            }
            return p.get(i) / p.get(0);
        };
    }

    @Generated
    private InverseAutoCorrelations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

