/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.MeasurementError;
import jdplus.toolkit.base.core.ssf.basic.TimeInvariantSsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.ISsfMeasurement;
import jdplus.toolkit.base.core.ssf.univariate.Measurement;

public class Ssf
implements ISsf {
    private final ISsfInitialization initializer;
    private final ISsfMeasurement measurement;
    private final ISsfDynamics dynamics;

    public static Ssf of(StateComponent cmp, ISsfLoading loading, double measurementError) {
        return new Ssf(cmp.initialization(), cmp.dynamics(), new Measurement(loading, MeasurementError.of(measurementError)));
    }

    public static Ssf of(StateComponent cmp, ISsfLoading loading) {
        return new Ssf(cmp.initialization(), cmp.dynamics(), new Measurement(loading, null));
    }

    public static Ssf of(ISsfInitialization initializer, ISsfDynamics dynamics, ISsfLoading loading) {
        return new Ssf(initializer, dynamics, new Measurement(loading, null));
    }

    public static Ssf of(ISsfInitialization initializer, ISsfDynamics dynamics, ISsfLoading loading, double measurementError) {
        return new Ssf(initializer, dynamics, new Measurement(loading, MeasurementError.of(measurementError)));
    }

    public static Ssf of(ISsfInitialization initializer, ISsfDynamics dynamics, ISsfLoading loading, ISsfError measurementError) {
        return new Ssf(initializer, dynamics, new Measurement(loading, measurementError));
    }

    public Ssf(ISsfInitialization initializer, ISsfDynamics dynamics, ISsfMeasurement measurement) {
        this.initializer = initializer;
        this.dynamics = dynamics;
        this.measurement = measurement;
    }

    @Override
    public ISsfInitialization initialization() {
        return this.initializer;
    }

    @Override
    public ISsfMeasurement measurement() {
        return this.measurement;
    }

    @Override
    public ISsfDynamics dynamics() {
        return this.dynamics;
    }

    @Override
    public boolean isTimeInvariant() {
        return this.dynamics.isTimeInvariant() && this.measurement.isTimeInvariant();
    }

    public String toString() {
        if (this.isTimeInvariant()) {
            return TimeInvariantSsf.toString(this);
        }
        return super.toString();
    }
}

