/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.basic.MeasurementError;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.ISsfMeasurement;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class Measurement
implements ISsfMeasurement {
    private final ISsfLoading loading;
    private final ISsfError error;

    public Measurement(@NonNull ISsfLoading loading, @Nullable ISsfError error) {
        if (loading == null) {
            throw new NullPointerException("loading is marked non-null but is null");
        }
        this.loading = loading;
        this.error = error;
    }

    public Measurement(@NonNull ISsfLoading loading, double var) {
        if (loading == null) {
            throw new NullPointerException("loading is marked non-null but is null");
        }
        this.loading = loading;
        this.error = MeasurementError.of(var);
    }

    @Override
    public ISsfLoading loading() {
        return this.loading;
    }

    @Override
    public ISsfError error() {
        return this.error;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }
}

