/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.univariate;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.DataBlockResults;
import jdplus.toolkit.base.core.ssf.DataResults;
import jdplus.toolkit.base.core.ssf.IStateResults;
import jdplus.toolkit.base.core.ssf.MatrixResults;
import jdplus.toolkit.base.core.ssf.ResultsRange;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.univariate.IFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;

public class DefaultFilteringResults
implements IFilteringResults,
IStateResults {
    private final DataBlockResults A;
    private final MatrixResults P;
    private final DataBlockResults M;
    private final DataResults e;
    private final DataResults f;
    private final ResultsRange range = new ResultsRange();

    protected DefaultFilteringResults(boolean cov) {
        this.A = new DataBlockResults();
        this.M = new DataBlockResults();
        this.P = cov ? new MatrixResults() : null;
        this.e = new DataResults();
        this.f = new DataResults();
    }

    public boolean isInitialized() {
        return this.A.isInitialized();
    }

    public ResultsRange getRange() {
        return this.range;
    }

    public static DefaultFilteringResults full() {
        return new DefaultFilteringResults(true);
    }

    public static DefaultFilteringResults light() {
        return new DefaultFilteringResults(false);
    }

    public void prepare(ISsf ssf, int start, int end) {
        int dim = ssf.getStateDim();
        this.A.prepare(dim, start, end);
        this.M.prepare(dim, start, end);
        this.e.prepare(start, end);
        this.f.prepare(start, end);
        if (this.P != null) {
            this.P.prepare(dim, start, end);
        }
    }

    @Override
    public void save(int t, UpdateInformation pe) {
        this.e.save(t, pe.get());
        this.f.save(t, pe.getVariance());
        this.M.save(t, pe.M());
    }

    @Override
    public void save(int t, State state, StateInfo info) {
        if (info != StateInfo.Forecast) {
            return;
        }
        this.A.save(t, state.a());
        if (this.P != null) {
            this.P.save(t, state.P());
        }
        this.range.add(t);
    }

    public boolean isMissing(int pos) {
        return this.e.isMissing(pos);
    }

    public double error(int pos) {
        return this.e.get(pos);
    }

    public double errorVariance(int pos) {
        return this.f.get(pos);
    }

    public DoubleSeq errors(boolean normalized, boolean clean) {
        DataBlock r = this.e.all();
        if (normalized) {
            r = DataBlock.of((DoubleSeq)r);
            DataBlock allf = this.f.all();
            r.apply(allf, (x, y) -> Double.isFinite(x) && Double.isFinite(y) ? x / Math.sqrt(y) : Double.NaN);
        }
        if (clean) {
            r = DataBlock.select((DoubleSeq)r, x -> Double.isFinite(x));
        }
        return r;
    }

    public DataBlock getComponent(int pos) {
        return this.A.item(pos);
    }

    public DataBlock getComponentVariance(int pos) {
        return this.P.item(pos, pos);
    }

    public DoubleSeq errors() {
        return this.e.asDoublesReader(true);
    }

    public DoubleSeq errorVariances() {
        return this.f.asDoublesReader(true);
    }

    public DataBlock a(int pos) {
        return this.A.datablock(pos);
    }

    public DataBlock M(int pos) {
        return this.M.datablock(pos);
    }

    public FastMatrix P(int pos) {
        return this.P.matrix(pos);
    }

    @Override
    public void clear() {
        this.e.clear();
        this.f.clear();
        this.A.clear();
        this.M.clear();
        if (this.P != null) {
            this.P.clear();
        }
        this.range.clear();
    }

    public int size() {
        return this.e.getLength();
    }

    public double var() {
        int m = 0;
        double ssq = 0.0;
        int n = this.e.getLength();
        for (int i = 0; i < n; ++i) {
            double err = this.error(i);
            if (!Double.isFinite(err)) continue;
            ++m;
            ssq += err * err / this.errorVariance(i);
        }
        return ssq / (double)m;
    }

    public double logDeterminant() {
        DeterminantalTerm det = new DeterminantalTerm();
        int n = this.e.getLength();
        for (int i = 0; i < n; ++i) {
            double verr;
            if (!Double.isFinite(this.error(i)) || !((verr = this.errorVariance(i)) > 1.0E-9)) continue;
            det.add(verr);
        }
        return det.getLogDeterminant();
    }
}

