/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class MultivariateUpdateInformation {
    private final DoubleSeq e;
    private final DoubleSeq u;
    @NonNull
    private final FastMatrix R;
    @NonNull
    private final FastMatrix M;
    @NonNull
    private final UpdateInformation.Status[] status;
    @NonNull
    private final int[] usedMeasurements;

    public MultivariateUpdateInformation(DoubleSeq e, FastMatrix R, FastMatrix M, UpdateInformation.Status[] status) {
        this.e = e;
        this.R = R;
        this.M = M;
        this.status = status;
        double[] pu = e.toArray();
        LowerTriangularMatrix.solveLx(R, DataBlock.of(pu));
        this.u = DoubleSeq.of((double[])pu);
        int nused = e.length();
        this.usedMeasurements = new int[nused];
        int j = 0;
        for (int i = 0; i < status.length; ++i) {
            if (status[i] == UpdateInformation.Status.MISSING) continue;
            this.usedMeasurements[j++] = i;
        }
    }

    public static int fillStatus(IMultivariateSsfData data, int pos, UpdateInformation.Status[] s) {
        int nvars = s.length;
        for (int i = 0; i < s.length; ++i) {
            if (data.isMissing(pos, i)) {
                s[i] = UpdateInformation.Status.MISSING;
                --nvars;
                continue;
            }
            s[i] = data.isConstraint(pos, i) ? UpdateInformation.Status.CONSTRAINT : UpdateInformation.Status.OBSERVATION;
        }
        return nvars;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public DoubleSeq getE() {
        return this.e;
    }

    @Generated
    public DoubleSeq getU() {
        return this.u;
    }

    @NonNull
    @Generated
    public FastMatrix getR() {
        return this.R;
    }

    @NonNull
    @Generated
    public FastMatrix getM() {
        return this.M;
    }

    @NonNull
    @Generated
    public UpdateInformation.Status[] getStatus() {
        return this.status;
    }

    @NonNull
    @Generated
    public int[] getUsedMeasurements() {
        return this.usedMeasurements;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultivariateUpdateInformation)) {
            return false;
        }
        MultivariateUpdateInformation other = (MultivariateUpdateInformation)o;
        DoubleSeq this$e = this.getE();
        DoubleSeq other$e = other.getE();
        if (this$e == null ? other$e != null : !this$e.equals(other$e)) {
            return false;
        }
        DoubleSeq this$u = this.getU();
        DoubleSeq other$u = other.getU();
        if (this$u == null ? other$u != null : !this$u.equals(other$u)) {
            return false;
        }
        FastMatrix this$R = this.getR();
        FastMatrix other$R = other.getR();
        if (this$R == null ? other$R != null : !this$R.equals(other$R)) {
            return false;
        }
        FastMatrix this$M = this.getM();
        FastMatrix other$M = other.getM();
        if (this$M == null ? other$M != null : !this$M.equals(other$M)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getStatus(), (Object[])other.getStatus())) {
            return false;
        }
        return Arrays.equals(this.getUsedMeasurements(), other.getUsedMeasurements());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DoubleSeq $e = this.getE();
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        DoubleSeq $u = this.getU();
        result = result * 59 + ($u == null ? 43 : $u.hashCode());
        FastMatrix $R = this.getR();
        result = result * 59 + ($R == null ? 43 : $R.hashCode());
        FastMatrix $M = this.getM();
        result = result * 59 + ($M == null ? 43 : $M.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getStatus());
        result = result * 59 + Arrays.hashCode(this.getUsedMeasurements());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "MultivariateUpdateInformation(e=" + String.valueOf(this.getE()) + ", u=" + String.valueOf(this.getU()) + ", R=" + String.valueOf(this.getR()) + ", M=" + String.valueOf(this.getM()) + ", status=" + Arrays.deepToString((Object[])this.getStatus()) + ", usedMeasurements=" + Arrays.toString(this.getUsedMeasurements()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private DoubleSeq e;
        @Generated
        private FastMatrix R;
        @Generated
        private FastMatrix M;
        @Generated
        private UpdateInformation.Status[] status;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder e(DoubleSeq e) {
            this.e = e;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder R(FastMatrix R) {
            this.R = R;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder M(FastMatrix M) {
            this.M = M;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder status(UpdateInformation.Status[] status) {
            this.status = status;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull MultivariateUpdateInformation build() {
            return new MultivariateUpdateInformation(this.e, this.R, this.M, this.status);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "MultivariateUpdateInformation.Builder(e=" + String.valueOf(this.e) + ", R=" + String.valueOf(this.R) + ", M=" + String.valueOf(this.M) + ", status=" + Arrays.deepToString((Object[])this.status) + ")";
        }
    }
}

