/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.basic.MeasurementError;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfMeasurements;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;

public class M2uAdapter {
    public static ISsfData of(IMultivariateSsfData data) {
        return new Data(data);
    }

    public static ISsf of(IMultivariateSsf mssf) {
        ISsfMeasurements measurements = mssf.measurements();
        int m = measurements.getCount();
        if (m > 1) {
            ISsfErrors errors = mssf.errors();
            if (errors != null && !errors.areIndependent()) {
                return null;
            }
            ISsfDynamics mdynamics = mssf.dynamics();
            Dynamics ndyn = new Dynamics(mdynamics, measurements.getCount());
            Loading nload = new Loading(measurements);
            Error ne = errors == null ? null : new Error(errors, measurements.getCount());
            return Ssf.of(mssf.initialization(), (ISsfDynamics)ndyn, (ISsfLoading)nload, ne);
        }
        ISsfInitialization initialization = mssf.initialization();
        ISsfDynamics dynamics = mssf.dynamics();
        ISsfErrors errors = mssf.errors();
        ISsfError error = null;
        if (errors != null) {
            if (errors.isTimeInvariant()) {
                FastMatrix h = FastMatrix.square(1);
                errors.H(0, h);
                error = MeasurementError.of(h.get(0, 0));
            } else {
                error = new Error(errors, 1);
            }
        }
        return Ssf.of(initialization, dynamics, measurements.loading(0), error);
    }

    static class Data
    implements ISsfData {
        private final int nvars;
        private final IMultivariateSsfData data;

        Data(IMultivariateSsfData data) {
            this.data = data;
            this.nvars = data.getVarsCount();
        }

        public double get(int pos) {
            return this.data.get(pos / this.nvars, pos % this.nvars);
        }

        @Override
        public boolean isMissing(int pos) {
            return this.data.isMissing(pos / this.nvars, pos % this.nvars);
        }

        @Override
        public boolean isConstraint(int pos) {
            return this.data.isConstraint(pos / this.nvars, pos % this.nvars);
        }

        public int length() {
            return this.data.getObsCount() * this.nvars;
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final ISsfDynamics mdynamics;
        private final int nstep;

        public Dynamics(ISsfDynamics mdynamics, int nstep) {
            this.mdynamics = mdynamics;
            this.nstep = nstep;
        }

        @Override
        public boolean isTimeInvariant() {
            return this.nstep == 1 && this.mdynamics.isTimeInvariant();
        }

        @Override
        public int getInnovationsDim() {
            return this.mdynamics.getInnovationsDim();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.V(pos / this.nstep, qm);
            }
        }

        @Override
        public boolean hasInnovations(int pos) {
            if (pos % this.nstep == this.nstep - 1) {
                return this.mdynamics.hasInnovations(pos / this.nstep);
            }
            return false;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return false;
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.S(pos / this.nstep, sm);
            }
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.addSU(pos / this.nstep, x, u);
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.XS(pos / this.nstep, x, xs);
            } else {
                xs.set(0.0);
            }
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.T(pos / this.nstep, tr);
            } else {
                tr.diagonal().set(1.0);
            }
        }

        @Override
        public void TX(int pos, DataBlock x) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.TX(pos / this.nstep, x);
            }
        }

        @Override
        public void TM(int pos, FastMatrix m) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.TM(pos / this.nstep, m);
            }
        }

        @Override
        public void TVT(int pos, FastMatrix m) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.TVT(pos / this.nstep, m);
            }
        }

        @Override
        public void XT(int pos, DataBlock x) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.XT(pos / this.nstep, x);
            }
        }

        @Override
        public void MT(int pos, FastMatrix m) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.MT(pos / this.nstep, m);
            }
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            if (pos % this.nstep == this.nstep - 1) {
                this.mdynamics.addV(pos / this.nstep, p);
            }
        }
    }

    static class Loading
    implements ISsfLoading {
        private final ISsfMeasurements measurements;
        private final int nvars;

        Loading(ISsfMeasurements measurements) {
            this.measurements = measurements;
            this.nvars = measurements.getCount();
        }

        @Override
        public boolean isTimeInvariant() {
            return this.measurements.getCount() == 1 && this.measurements.loading(0).isTimeInvariant();
        }

        @Override
        public void Z(int pos, DataBlock z) {
            this.measurements.loading(pos % this.nvars).Z(pos / this.nvars, z);
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return this.measurements.loading(pos % this.nvars).ZX(pos / this.nvars, m);
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            return this.measurements.loading(pos % this.nvars).ZVZ(pos / this.nvars, V);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            this.measurements.loading(pos % this.nvars).VpZdZ(pos / this.nvars, V, d);
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            this.measurements.loading(pos % this.nvars).XpZd(pos / this.nvars, x, d);
        }
    }

    static class Error
    implements ISsfError {
        private final ISsfErrors errors;
        private final int nvars;
        private final FastMatrix H;
        private int hpos = -1;

        Error(ISsfErrors errors, int nvars) {
            this.errors = errors.isTimeInvariant() ? null : errors;
            this.nvars = nvars;
            this.H = FastMatrix.square(nvars);
            if (errors.isTimeInvariant()) {
                errors.H(0, this.H);
            }
        }

        @Override
        public boolean isTimeInvariant() {
            return this.errors.isTimeInvariant();
        }

        @Override
        public double at(int pos) {
            int i = pos % this.nvars;
            if (this.errors == null) {
                return this.H.get(i, i);
            }
            int j = pos / this.nvars;
            if (j != this.hpos) {
                this.errors.H(j, this.H);
                this.hpos = j;
            }
            return this.H.get(i, i);
        }
    }
}

