/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class ProfileLikelihood
implements Likelihood {
    private double ll;
    private double ssqerr;
    private double ldet;
    private int n;
    private DataBlock b;
    private FastMatrix varB;
    private double[] res;

    public void clear() {
        this.ll = 0.0;
        this.ssqerr = 0.0;
        this.ldet = 0.0;
        this.n = 0;
        this.b = null;
        this.varB = null;
    }

    @Override
    public double factor() {
        return Math.exp(this.ldet / (double)this.n);
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.n;
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double ser() {
        return Math.sqrt(this.ssqerr / (double)this.n);
    }

    @Override
    public double sigma2() {
        return this.ssqerr / (double)this.n;
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    @Override
    public DoubleSeq e() {
        return this.res == null ? DoubleSeq.empty() : DoubleSeq.of((double[])this.res);
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        this.ssqerr /= factor * factor;
        this.ll += (double)this.n * Math.log(factor);
        if (this.res != null) {
            int i = 0;
            while (i < this.res.length) {
                int n = i++;
                this.res[n] = this.res[n] / factor;
            }
        }
    }

    public boolean set(double ssqerr, double ldet, DataBlock b, FastMatrix varB, int n) {
        this.ssqerr = ssqerr;
        this.ldet = ldet;
        this.b = b;
        this.varB = varB;
        this.n = n;
        this.calcll();
        return true;
    }

    public void set(DoubleSeq e) {
        this.res = e.toArray();
    }

    private void calcll() {
        this.ll = -0.5 * ((double)this.n * Math.log(Math.PI * 2) + (double)this.n * (1.0 + Math.log(this.ssqerr / (double)this.n)) + this.ldet);
    }

    public void add(Likelihood ll) {
        this.n += ll.dim();
        this.ssqerr += ll.ssq();
        this.ldet += ll.logDeterminant();
        this.calcll();
    }

    public DoubleSeq getDiffuseEffects() {
        return this.b;
    }

    public FastMatrix getVarianceOfDiffuseEffects() {
        return this.varB;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ll=").append(this.logLikelihood()).append("\r\n");
        builder.append("n=").append(this.dim()).append("\r\n");
        builder.append("ssq=").append(this.ssq()).append("\r\n");
        builder.append("ldet=").append(this.logDeterminant()).append("\r\n");
        return builder.toString();
    }
}

