/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.NumericalDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.SsqNumericalDerivatives;
import jdplus.toolkit.base.core.ssf.SsfException;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihoodFunction;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodFunctionPoint;

public class MarginalLikelihoodFunctionPoint<S, F extends ISsf>
implements LikelihoodFunctionPoint<MarginalLikelihood> {
    private final F currentSsf;
    private final S current;
    private final MarginalLikelihood ll;
    private final DoubleSeq p;
    private final DoubleSeq E;
    private final MarginalLikelihoodFunction<S, F> fn;

    public MarginalLikelihoodFunctionPoint(MarginalLikelihoodFunction<S, F> fn, DoubleSeq p) {
        Object e;
        MarginalLikelihood ml;
        this.fn = fn;
        this.p = DataBlock.of(p);
        this.current = fn.getMapping().map(p);
        this.currentSsf = fn.getBuilder().buildSsf(this.current);
        try {
            ml = DkToolkit.marginalLikelihood(this.currentSsf, fn.getData(), fn.isScalingFactor(), fn.isResiduals());
            e = ml.e();
            if (fn.isScalingFactor()) {
                DataBlock r = DataBlock.select(e, x -> Double.isFinite(x));
                if (fn.isMaximumLikelihood()) {
                    double factor = Math.sqrt(ml.factor());
                    r.mul(factor);
                }
                e = r;
            }
        }
        catch (SsfException err) {
            ml = null;
            e = null;
        }
        this.ll = ml;
        this.E = e;
    }

    public F getSsf() {
        return this.currentSsf;
    }

    public S getCore() {
        return this.current;
    }

    @Override
    public DoubleSeq getE() {
        return this.E;
    }

    @Override
    public MarginalLikelihood getLikelihood() {
        return this.ll;
    }

    @Override
    public DoubleSeq getParameters() {
        return this.p;
    }

    @Override
    public double getSsqE() {
        if (this.ll == null) {
            return Double.NaN;
        }
        return this.fn.isMaximumLikelihood() ? this.ll.ssq() * this.ll.factor() : this.ll.ssq();
    }

    @Override
    public double getValue() {
        if (this.ll == null) {
            return Double.NaN;
        }
        if (this.fn.isLog()) {
            return this.fn.isMaximumLikelihood() ? -this.ll.logLikelihood() : Math.log(this.ll.ssq());
        }
        return this.fn.isMaximumLikelihood() ? this.ll.ssq() * this.ll.factor() : this.ll.ssq();
    }

    @Override
    public ISsqFunction getSsqFunction() {
        return this.fn;
    }

    @Override
    public IFunction getFunction() {
        return this.fn;
    }

    @Override
    public IFunctionDerivatives derivatives() {
        return new NumericalDerivatives(this, this.fn.isSymmetric(), this.fn.isMultiThreaded());
    }

    @Override
    public ISsqFunctionDerivatives ssqDerivatives() {
        return new SsqNumericalDerivatives(this, this.fn.isSymmetric(), this.fn.isMultiThreaded());
    }
}

