/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockStorage;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.dk.DiffuseDisturbanceSmoother;
import jdplus.toolkit.base.core.ssf.univariate.DefaultDisturbanceSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.DisturbanceSmoother;
import jdplus.toolkit.base.core.ssf.univariate.IDisturbanceSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class FastStateSmoother {
    private final ISsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfError error;

    public FastStateSmoother(ISsf ssf) {
        this.ssf = ssf;
        this.dynamics = ssf.dynamics();
        this.error = ssf.measurementError();
    }

    public DataBlockStorage process(ISsfData data) {
        int dim = this.ssf.getStateDim();
        int n = data.length();
        DataBlockStorage storage = new DataBlockStorage(dim, n);
        DefaultDisturbanceSmoothingResults srslts = DefaultDisturbanceSmoothingResults.light(this.error != null);
        srslts.prepare(this.ssf, 0, n);
        DataBlock a = this.initialState(data, srslts);
        storage.save(0, a);
        int cur = 1;
        while (cur < n) {
            this.dynamics.TX(cur - 1, a);
            if (this.dynamics.hasInnovations(cur - 1)) {
                DataBlock u = srslts.u(cur);
                this.dynamics.addSU(cur - 1, a, u);
            }
            storage.save(cur++, a);
        }
        return storage;
    }

    private DataBlock initialState(ISsfData data, IDisturbanceSmoothingResults srslts) {
        if (this.ssf.initialization().isDiffuse()) {
            DiffuseDisturbanceSmoother sm = DiffuseDisturbanceSmoother.builder(this.ssf).calcVariance(false).rescaleVariance(false).build();
            sm.process(data, srslts);
            return sm.firstSmoothedState();
        }
        DisturbanceSmoother sm = DisturbanceSmoother.builder(this.ssf).calcVariance(false).rescaleVariance(false).build();
        sm.process(data, srslts, 0);
        return sm.firstSmoothedState();
    }
}

