/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.dk.BaseDiffuseSmoother;
import jdplus.toolkit.base.core.ssf.dk.DefaultDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.DiffuseState;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinarySmoother;

public class DiffuseSmoother
extends BaseDiffuseSmoother {
    private DiffuseState state;
    private DefaultDiffuseFilteringResults frslts;

    public static Builder builder(ISsf ssf) {
        return new Builder(ssf);
    }

    private DiffuseSmoother(ISsf ssf, boolean calcvar, boolean rescalevar) {
        super(ssf, calcvar, rescalevar);
    }

    public boolean process(ISsfData data, ISmoothingResults sresults) {
        DefaultDiffuseFilteringResults fresults = DkToolkit.filter(this.ssf, data, true);
        return this.process(data.length(), fresults, sresults);
    }

    public boolean process(int endpos, DefaultDiffuseFilteringResults results, ISmoothingResults sresults) {
        this.frslts = results;
        this.srslts = sresults;
        this.initSmoother();
        this.ordinarySmoothing(this.ssf, endpos);
        int t = this.frslts.getEndDiffusePosition();
        while (--t >= 0) {
            this.loadInfo(t);
            this.iterate(t);
            if (!this.hasinfo) continue;
            this.srslts.save(t, this.state, StateInfo.Smoothed);
            this.srslts.saveSmoothation(t, this.u, this.uVariance);
            this.srslts.saveR(t, this.Rf, this.N0);
        }
        if (this.rescalevar) {
            this.srslts.rescaleVariances(this.frslts.var());
        }
        return true;
    }

    private void initSmoother() {
        int dim = this.ssf.getStateDim();
        this.state = new DiffuseState(dim);
        this.Rf = DataBlock.make(dim);
        this.C = DataBlock.make(dim);
        this.Ri = DataBlock.make(dim);
        this.Ci = DataBlock.make(dim);
        if (this.calcvar) {
            this.tmp0 = DataBlock.make(dim);
            this.tmp1 = DataBlock.make(dim);
            this.Z = DataBlock.make(dim);
            this.N0 = FastMatrix.square(dim);
            this.N1 = FastMatrix.square(dim);
            this.N2 = FastMatrix.square(dim);
        }
    }

    private void loadInfo(int pos) {
        this.e = this.frslts.error(pos);
        this.f = this.frslts.errorVariance(pos);
        this.fi = this.frslts.diffuseNorm2(pos);
        this.C.copy(this.frslts.M(pos));
        if (this.fi != 0.0) {
            this.Ci.copy(this.frslts.Mi(pos));
            this.Ci.mul(1.0 / this.fi);
            this.C.addAY(-this.f, this.Ci);
            this.C.mul(1.0 / this.fi);
        } else {
            this.C.mul(1.0 / this.f);
            this.Ci.set(0.0);
        }
        this.missing = !Double.isFinite(this.e);
        DataBlock fa = this.frslts.a(pos);
        boolean bl = this.hasinfo = fa != null;
        if (!this.hasinfo) {
            return;
        }
        this.state.a().copy(fa);
        if (this.calcvar) {
            this.state.P().copy(this.frslts.P(pos));
            this.state.Pi().copy(this.frslts.Pi(pos));
            this.Z.set(0.0);
            this.loading.Z(pos, this.Z);
        }
    }

    @Override
    protected void updateA(int pos) {
        DataBlock a = this.state.a();
        if (this.calcvar) {
            a.addProduct(this.Rf, this.state.P().columnsIterator());
            a.addProduct(this.Ri, this.state.Pi().columnsIterator());
        } else {
            a.addProduct(this.Rf, this.frslts.P(pos).columnsIterator());
            a.addProduct(this.Ri, this.frslts.Pi(pos).columnsIterator());
        }
    }

    @Override
    protected void updateP(int pos) {
        FastMatrix P = this.state.P();
        FastMatrix PN0P = SymmetricMatrix.XtSX(this.N0, P);
        FastMatrix Pi = this.state.Pi();
        FastMatrix PN2P = SymmetricMatrix.XtSX(this.N2, Pi);
        FastMatrix PN1 = GeneralMatrix.AB(P, this.N1);
        FastMatrix PN1Pi = GeneralMatrix.AB(PN1, Pi);
        P.sub(PN0P);
        P.sub(PN2P);
        P.sub(PN1Pi);
        P.subTranspose(PN1Pi);
        SymmetricMatrix.reenforceSymmetry(P);
    }

    private void ordinarySmoothing(ISsf ssf, int end) {
        OrdinarySmoother smoother = OrdinarySmoother.builder(ssf).calcVariance(this.calcvar).build();
        int beg = this.frslts.getEndDiffusePosition();
        smoother.process(beg, end, this.frslts, this.srslts);
        this.Rf.copy(smoother.getFinalR());
        if (this.calcvar) {
            this.N0.copy(smoother.getFinalN());
        }
    }

    public DefaultDiffuseFilteringResults getFilteringResults() {
        return this.frslts;
    }

    public static class Builder {
        private final ISsf ssf;
        private boolean rescaleVariance = false;
        private boolean calcVariance = true;

        public Builder(ISsf ssf) {
            this.ssf = ssf;
        }

        public Builder rescaleVariance(boolean rescale) {
            this.rescaleVariance = rescale;
            if (rescale) {
                this.calcVariance = true;
            }
            return this;
        }

        public Builder calcVariance(boolean calc) {
            this.calcVariance = calc;
            if (!calc) {
                this.rescaleVariance = false;
            }
            return this;
        }

        public DiffuseSmoother build() {
            return new DiffuseSmoother(this.ssf, this.calcVariance, this.rescaleVariance);
        }
    }
}

