/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;

public abstract class BaseDiffuseSmoother {
    protected final ISsf ssf;
    protected final ISsfDynamics dynamics;
    protected final ISsfLoading loading;
    protected final boolean calcvar;
    protected final boolean rescalevar;
    protected ISmoothingResults srslts;
    protected double e;
    protected double f;
    protected double fi;
    protected double u;
    protected double uVariance;
    protected DataBlock C;
    protected DataBlock Ci;
    protected DataBlock Rf;
    protected DataBlock Ri;
    protected DataBlock tmp0;
    protected DataBlock tmp1;
    protected DataBlock Z;
    protected FastMatrix N0;
    protected FastMatrix N1;
    protected FastMatrix N2;
    protected boolean missing;
    protected boolean hasinfo;

    protected BaseDiffuseSmoother(ISsf ssf, boolean calcvar, boolean rescalevar) {
        this.ssf = ssf;
        this.calcvar = calcvar;
        this.rescalevar = rescalevar;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
    }

    public ISmoothingResults getResults() {
        return this.srslts;
    }

    protected void iterate(int pos) {
        this.iterateR(pos);
        this.updateA(pos);
        if (this.calcvar) {
            this.iterateN(pos);
            this.updateP(pos);
        }
    }

    protected abstract void updateA(int var1);

    protected abstract void updateP(int var1);

    private void xQ(int pos, DataBlock x) {
        this.loading.XpZd(pos, x, -x.dot(this.C));
    }

    private void XQ(int pos, DataBlockIterator X) {
        while (X.hasNext()) {
            this.xQ(pos, X.next());
        }
    }

    private void xQi(int pos, DataBlock x) {
        this.loading.XpZd(pos, x, -x.dot(this.Ci));
    }

    private void XQi(int pos, DataBlockIterator X) {
        while (X.hasNext()) {
            this.xQi(pos, X.next());
        }
    }

    private void iterateN(int pos) {
        if (this.missing || this.f == 0.0 && this.fi == 0.0) {
            this.iterateMissingN(pos);
        } else if (this.fi == 0.0) {
            this.iterateRegularN(pos);
        } else {
            this.iterateDiffuseN(pos);
        }
    }

    private void iterateMissingN(int pos) {
        this.tvt(pos, this.N0);
        this.tvt(pos, this.N1);
        this.tvt(pos, this.N2);
        this.u = Double.NaN;
        this.uVariance = Double.NaN;
    }

    private void iterateRegularN(int pos) {
        DataBlock k = this.C.deepClone();
        this.dynamics.TX(pos, k);
        this.uVariance = 1.0 / this.f + QuadraticForm.apply(this.N0, k);
        this.tvt(pos, this.N0);
        this.XQ(pos, this.N0.rowsIterator());
        this.XQ(pos, this.N0.columnsIterator());
        this.loading.VpZdZ(pos, this.N0, 1.0 / this.f);
        this.tvt(pos, this.N1);
        this.XQ(pos, this.N1.columnsIterator());
        this.tvt(pos, this.N2);
    }

    private void iterateDiffuseN(int pos) {
        this.tvt(pos, this.N0);
        this.tvt(pos, this.N1);
        this.tvt(pos, this.N2);
        this.tmp0.product(this.C, this.N0.columnsIterator());
        this.tmp1.product(this.C, this.N1.columnsIterator());
        double kn0k = this.tmp0.dot(this.C);
        this.XQi(pos, this.N0.rowsIterator());
        this.XQi(pos, this.N0.columnsIterator());
        this.XQi(pos, this.N1.rowsIterator());
        this.XQi(pos, this.N2.columnsIterator());
        this.XQi(pos, this.N2.rowsIterator());
        this.XQi(pos, this.N1.columnsIterator());
        this.xQi(pos, this.tmp0);
        this.xQi(pos, this.tmp1);
        DataBlockIterator n1cols = this.N1.columnsIterator();
        DataBlockIterator n2cols = this.N2.columnsIterator();
        DoubleSeqCursor.OnMutable z = this.Z.cursor();
        double h = kn0k - this.f / (this.fi * this.fi);
        while (n1cols.hasNext()) {
            double zx = z.getAndNext();
            if (zx != 0.0) {
                this.loading.XpZd(pos, n1cols.next(), zx / this.fi);
                this.loading.XpZd(pos, n2cols.next(), zx * h);
                continue;
            }
            n1cols.next();
            n2cols.next();
        }
        this.subZ(pos, this.N1.rowsIterator(), this.tmp0);
        this.subZ(pos, this.N1.columnsIterator(), this.tmp0);
        this.subZ(pos, this.N2.rowsIterator(), this.tmp1);
        this.subZ(pos, this.N2.columnsIterator(), this.tmp1);
    }

    private void tvt(int pos, FastMatrix N) {
        this.dynamics.MT(pos, N);
        this.dynamics.TtM(pos, N);
    }

    private void subZ(int pos, DataBlockIterator rows, DataBlock b) {
        DoubleSeqCursor.OnMutable cell = b.cursor();
        while (rows.hasNext()) {
            double cur = cell.getAndNext();
            DataBlock row = rows.next();
            if (cur == 0.0) continue;
            this.loading.XpZd(pos, row, -cur);
        }
    }

    private void iterateR(int pos) {
        if (this.fi == 0.0) {
            this.iterateRegularR(pos);
        } else {
            this.iterateDiffuseR(pos);
        }
    }

    private void iterateRegularR(int pos) {
        this.dynamics.XT(pos, this.Rf);
        this.dynamics.XT(pos, this.Ri);
        if (!this.missing && this.f != 0.0) {
            this.u = this.e / this.f - this.Rf.dot(this.C);
            this.loading.XpZd(pos, this.Rf, this.u);
        } else {
            this.u = Double.NaN;
        }
    }

    private void iterateDiffuseR(int pos) {
        this.dynamics.XT(pos, this.Rf);
        this.dynamics.XT(pos, this.Ri);
        if (!this.missing) {
            double ci = this.e / this.fi - this.Ri.dot(this.Ci) - this.Rf.dot(this.C);
            this.loading.XpZd(pos, this.Ri, ci);
            this.u = -this.Rf.dot(this.Ci);
            this.loading.XpZd(pos, this.Rf, this.u);
        }
    }
}

